/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.core.urlresolvers.DefaultUrlResolver;
import net.roboconf.core.urlresolvers.IUrlResolver;
import org.ops4j.pax.url.mvn.MavenResolver;

public class MavenUrlResolver
extends DefaultUrlResolver {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final MavenResolver mavenResolver;

    public MavenUrlResolver(MavenResolver mavenResolver) {
        this.mavenResolver = mavenResolver;
    }

    public IUrlResolver.ResolvedFile resolve(String url) throws IOException {
        IUrlResolver.ResolvedFile resolvedFile;
        if (url.toLowerCase().startsWith("mvn:")) {
            if (this.mavenResolver == null) {
                throw new IOException("No Maven resolver was available.");
            }
            this.logger.fine("Resolving a Maven URL: " + url);
            File f = this.mavenResolver.resolve(url);
            resolvedFile = new IUrlResolver.ResolvedFile(f, false);
        } else {
            resolvedFile = super.resolve(url);
        }
        return resolvedFile;
    }
}

