/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.utils;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.exceptions.InvalidApplicationException;
import net.roboconf.dm.rest.services.internal.errors.RestError;

public final class RestServicesUtils {
    private RestServicesUtils() {
    }

    public static Response.ResponseBuilder handleError(int status, RestError restError, String lang) {
        ArrayList<RestError> errors = new ArrayList<RestError>();
        errors.add(restError);
        if (restError.getException() instanceof InvalidApplicationException) {
            errors.addAll(((InvalidApplicationException)((Object)restError.getException())).getErrors());
        }
        StringBuilder sb = new StringBuilder();
        String sep = "\n\n";
        for (String s : RoboconfErrorHelpers.formatErrors(errors, null, (boolean)false).values()) {
            sb.append(s);
            sb.append(sep);
            sep = "\n";
        }
        String msg = sb.toString().trim().replaceAll("\"", "\\\"").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t");
        return Response.status((int)status).entity((Object)("{\"reason\":\"" + msg + "\"}"));
    }

    public static Response.ResponseBuilder handleError(Response.Status status, RestError restError, String lang) {
        return RestServicesUtils.handleError(status.getStatusCode(), restError, lang);
    }

    public static String lang(Manager manager) {
        return manager.preferencesMngr().get("user.language");
    }
}

