/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.websocket;

import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.rest.services.internal.ServletRegistrationComponent;
import net.roboconf.dm.rest.services.internal.websocket.WebSocketHandler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class RoboconfWebSocket
implements WebSocketListener {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    Session session;

    public void onWebSocketClose(int statusCode, String reason) {
        this.logger.info("A web socket connection is about to be closed. Session origin: " + this.session.getRemoteAddress());
        WebSocketHandler.removeSession(this.session);
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        session.setIdleTimeout(-1L);
        this.logger.info("A web socket connection was established. Session origin: " + session.getRemoteAddress());
        WebSocketHandler.addSession(session);
    }

    public void onWebSocketError(Throwable cause) {
        this.logger.severe("An error related to web sockets occurred. Session origin: " + this.session.getRemoteAddress());
        Utils.logException((Logger)this.logger, (Throwable)new Exception(cause));
        ServletRegistrationComponent.WS_CONNECTION_ERRORS_COUNT.incrementAndGet();
    }

    public void onWebSocketText(String message) {
        this.logger.finest("An unexpected text message was received on the web socket. Session origin: " + this.session.getRemoteAddress());
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.logger.finest("An unexpected binary message was received on the web socket. Session origin: " + this.session.getRemoteAddress());
    }
}

