/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.scheduler.internal;

import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.Manager;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CommandExecutionJob
implements Job {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        String appName = (String)context.getJobDetail().getJobDataMap().get("application-name");
        String jobName = (String)context.getJobDetail().getJobDataMap().get("job-name");
        String commandsFileName = (String)context.getJobDetail().getJobDataMap().get("command-file-name");
        try {
            Manager manager = (Manager)context.getScheduler().getContext().get("manager");
            Application app = manager.applicationMngr().findApplicationByName(appName);
            manager.commandsMngr().execute(app, commandsFileName, 1, jobName);
        }
        catch (Exception e) {
            this.logger.warning("An error occurred while executing job " + jobName + " (command file =" + commandsFileName + ").");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }
}

