/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.scheduler.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.runtime.ScheduledJob;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.events.IDmListener;
import net.roboconf.dm.scheduler.IScheduler;
import net.roboconf.dm.scheduler.internal.CommandExecutionJob;
import net.roboconf.dm.scheduler.internal.ManagerListener;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class RoboconfScheduler
implements IScheduler,
Pojo {
    InstanceManager __IM;
    static final String JOB_ID = "id";
    static final String JOB_NAME = "job-name";
    static final String APP_NAME = "application-name";
    static final String CMD_NAME = "command-file-name";
    static final String CRON = "cron";
    static final String MANAGER = "manager";
    static final String PROJECT_DIR_SCHEDULER = "scheduler";
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FdmListener;
    IDmListener dmListener;
    private boolean __Fscheduler;
    Scheduler scheduler;
    private boolean __Fmanager;
    Manager manager;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MsetManager$net_roboconf_dm_management_Manager;
    boolean __MloadJobs;
    boolean __MlistJobs;
    boolean __MsaveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdeleteJob$java_lang_String;
    boolean __MfindJobProperties$java_lang_String;
    boolean __MgetSchedulerDirectory;
    boolean __MgetJobFile$java_lang_String;
    boolean __MvalidProperties$java_util_Properties;
    boolean __MscheduleJob$java_util_Properties;
    boolean __MunscheduleJob$java_lang_String;
    boolean __Mfrom$java_util_Properties;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    IDmListener __getdmListener() {
        if (!this.__FdmListener) {
            return this.dmListener;
        }
        return (IDmListener)this.__IM.onGet((Object)this, "dmListener");
    }

    void __setdmListener(IDmListener iDmListener) {
        if (!this.__FdmListener) {
            this.dmListener = iDmListener;
            return;
        }
        this.__IM.onSet((Object)this, "dmListener", (Object)iDmListener);
    }

    Scheduler __getscheduler() {
        if (!this.__Fscheduler) {
            return this.scheduler;
        }
        return (Scheduler)this.__IM.onGet((Object)this, PROJECT_DIR_SCHEDULER);
    }

    void __setscheduler(Scheduler scheduler) {
        if (!this.__Fscheduler) {
            this.scheduler = scheduler;
            return;
        }
        this.__IM.onSet((Object)this, PROJECT_DIR_SCHEDULER, (Object)scheduler);
    }

    Manager __getmanager() {
        if (!this.__Fmanager) {
            return this.manager;
        }
        return (Manager)this.__IM.onGet((Object)this, MANAGER);
    }

    void __setmanager(Manager manager) {
        if (!this.__Fmanager) {
            this.manager = manager;
            return;
        }
        this.__IM.onSet((Object)this, MANAGER, (Object)manager);
    }

    public RoboconfScheduler() {
        this(null);
    }

    private RoboconfScheduler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public void start() throws Exception {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() throws Exception {
        this.__getlogger().info("Roboconf's scheduler is starting...");
        File schedulerDirectory = this.getSchedulerDirectory();
        Utils.createDirectory((File)schedulerDirectory);
        StringBuilder quartzProperties = new StringBuilder();
        quartzProperties.append("org.quartz.scheduler.instanceName: Roboconf Quartz Scheduler\n");
        quartzProperties.append("org.quartz.threadPool.threadCount = 3\n");
        quartzProperties.append("org.quartz.jobStore.class = org.quartz.simpl.RAMJobStore\n");
        quartzProperties.append("org.quartz.scheduler.skipUpdateCheck: false\n");
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(new ByteArrayInputStream(quartzProperties.toString().getBytes(StandardCharsets.UTF_8)));
        this.__setscheduler(factory.getScheduler());
        this.__getscheduler().start();
        this.__getscheduler().getContext().put(MANAGER, (Object)this.__getmanager());
        this.__setdmListener(new ManagerListener(this));
        this.__getmanager().listenerAppears(this.__getdmListener());
        this.loadJobs();
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() throws Exception {
        this.__getlogger().info("Roboconf's scheduler is stopping...");
        if (this.__getmanager() != null) {
            this.__getmanager().listenerDisappears(this.__getdmListener());
            this.__setdmListener(null);
        }
        if (this.__getscheduler() != null) {
            this.__getscheduler().shutdown();
            this.__setscheduler(null);
        }
    }

    public void setManager(Manager manager) {
        if (!this.__MsetManager$net_roboconf_dm_management_Manager) {
            this.__M_setManager(manager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setManager$net_roboconf_dm_management_Manager", new Object[]{manager});
            this.__M_setManager(manager);
            this.__IM.onExit((Object)this, "setManager$net_roboconf_dm_management_Manager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setManager$net_roboconf_dm_management_Manager", throwable);
            throw throwable;
        }
    }

    private void __M_setManager(Manager manager) {
        this.__setmanager(manager);
    }

    @Override
    public void loadJobs() {
        if (!this.__MloadJobs) {
            this.__M_loadJobs();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadJobs", new Object[0]);
            this.__M_loadJobs();
            this.__IM.onExit((Object)this, "loadJobs", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadJobs", throwable);
            throw throwable;
        }
    }

    private void __M_loadJobs() {
        this.__getlogger().fine("Roboconf's scheduler is loading jobs...");
        for (File f : Utils.listAllFiles((File)this.getSchedulerDirectory(), (String)".properties")) {
            try {
                Properties props = Utils.readPropertiesFileQuietly((File)f, (Logger)this.__getlogger());
                props.setProperty(JOB_ID, Utils.removeFileExtension((String)f.getName()));
                if (this.validProperties(props)) {
                    this.scheduleJob(props);
                    continue;
                }
                this.__getlogger().warning("Skipped schedule for a job. There are invalid or missing job properties in " + f.getName());
            }
            catch (Exception e) {
                this.__getlogger().warning("Failed to load a scheduled job from " + f.getName());
                Utils.logException((Logger)this.__getlogger(), (Throwable)e);
            }
        }
    }

    @Override
    public List<ScheduledJob> listJobs() {
        List<ScheduledJob> list;
        if (!this.__MlistJobs) {
            return this.__M_listJobs();
        }
        try {
            this.__IM.onEntry((Object)this, "listJobs", new Object[0]);
            list = this.__M_listJobs();
            this.__IM.onExit((Object)this, "listJobs", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listJobs", throwable);
            throw throwable;
        }
        return list;
    }

    private List<ScheduledJob> __M_listJobs() {
        this.__getlogger().fine("Roboconf's scheduler is listing jobs...");
        ArrayList<ScheduledJob> result = new ArrayList<ScheduledJob>();
        for (File f : Utils.listAllFiles((File)this.getSchedulerDirectory(), (String)".properties")) {
            Properties props = Utils.readPropertiesFileQuietly((File)f, (Logger)this.__getlogger());
            if (props.isEmpty()) continue;
            props.put(JOB_ID, Utils.removeFileExtension((String)f.getName()));
            ScheduledJob job = this.from(props);
            result.add(job);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String saveJob(String jobId, String jobName, String cmdName, String cron, String appName) throws IOException, IllegalArgumentException {
        String string;
        if (!this.__MsaveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_saveJob(jobId, jobName, cmdName, cron, appName);
        }
        try {
            this.__IM.onEntry((Object)this, "saveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{jobId, jobName, cmdName, cron, appName});
            string = this.__M_saveJob(jobId, jobName, cmdName, cron, appName);
            this.__IM.onExit((Object)this, "saveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_saveJob(String jobId, String jobName, String cmdName, String cron, String appName) throws IOException, IllegalArgumentException {
        Properties props = new Properties();
        if (jobId == null) {
            jobId = UUID.randomUUID().toString();
        }
        if (jobName != null) {
            props.setProperty(JOB_NAME, jobName);
        }
        if (cmdName != null) {
            props.setProperty(CMD_NAME, cmdName);
        }
        if (appName != null) {
            props.setProperty(APP_NAME, appName);
        }
        if (cron != null) {
            props.setProperty(CRON, cron);
        }
        String result = null;
        if (this.validProperties(props)) {
            this.__getlogger().fine("Roboconf's scheduler is about to save a job as " + jobName);
            Application app = this.__getmanager().applicationMngr().findApplicationByName(appName);
            if (app == null) {
                throw new IllegalArgumentException(appName + " does not exist");
            }
            if (!this.__getmanager().commandsMngr().listCommands(app).contains(cmdName)) {
                throw new IllegalArgumentException("Command " + cmdName + " does not exist");
            }
            this.unscheduleJob(jobId);
            try {
                props.setProperty(JOB_ID, jobId);
                this.scheduleJob(props);
                result = jobId;
                props.remove(JOB_ID);
                Utils.createDirectory((File)this.getSchedulerDirectory());
                Utils.writePropertiesFile((Properties)props, (File)this.getJobFile(jobId));
                this.__getlogger().fine("Roboconf's scheduler has just saved a job as " + jobName);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    @Override
    public void deleteJob(String jobId) throws IOException {
        if (!this.__MdeleteJob$java_lang_String) {
            this.__M_deleteJob(jobId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteJob$java_lang_String", new Object[]{jobId});
            this.__M_deleteJob(jobId);
            this.__IM.onExit((Object)this, "deleteJob$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteJob$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_deleteJob(String jobId) throws IOException {
        this.__getlogger().fine("Roboconf's scheduler is about to delete a job with ID " + jobId);
        try {
            this.unscheduleJob(jobId);
        }
        catch (IOException e) {
            this.__getlogger().warning("Failed to remove a scheduled job. Job's id: " + jobId);
            throw e;
        }
    }

    @Override
    public ScheduledJob findJobProperties(String jobId) {
        ScheduledJob scheduledJob;
        if (!this.__MfindJobProperties$java_lang_String) {
            return this.__M_findJobProperties(jobId);
        }
        try {
            this.__IM.onEntry((Object)this, "findJobProperties$java_lang_String", new Object[]{jobId});
            scheduledJob = this.__M_findJobProperties(jobId);
            this.__IM.onExit((Object)this, "findJobProperties$java_lang_String", (Object)scheduledJob);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findJobProperties$java_lang_String", throwable);
            throw throwable;
        }
        return scheduledJob;
    }

    private ScheduledJob __M_findJobProperties(String jobId) {
        this.__getlogger().fine("Roboconf's scheduler is about to find the properties of the job whose ID is " + jobId);
        ScheduledJob result = null;
        File f = this.getJobFile(jobId);
        if (f.isFile()) {
            Properties props = Utils.readPropertiesFileQuietly((File)f, (Logger)this.__getlogger());
            props.put(JOB_ID, jobId);
            result = this.from(props);
        }
        return result;
    }

    File getSchedulerDirectory() {
        File file;
        if (!this.__MgetSchedulerDirectory) {
            return this.__M_getSchedulerDirectory();
        }
        try {
            this.__IM.onEntry((Object)this, "getSchedulerDirectory", new Object[0]);
            file = this.__M_getSchedulerDirectory();
            this.__IM.onExit((Object)this, "getSchedulerDirectory", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSchedulerDirectory", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_getSchedulerDirectory() {
        return new File(this.__getmanager().configurationMngr().getWorkingDirectory(), PROJECT_DIR_SCHEDULER);
    }

    File getJobFile(String jobId) {
        File file;
        if (!this.__MgetJobFile$java_lang_String) {
            return this.__M_getJobFile(jobId);
        }
        try {
            this.__IM.onEntry((Object)this, "getJobFile$java_lang_String", new Object[]{jobId});
            file = this.__M_getJobFile(jobId);
            this.__IM.onExit((Object)this, "getJobFile$java_lang_String", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJobFile$java_lang_String", throwable);
            throw throwable;
        }
        return file;
    }

    private File __M_getJobFile(String jobId) {
        return new File(this.getSchedulerDirectory(), jobId + ".properties");
    }

    boolean validProperties(Properties props) {
        boolean bl;
        if (!this.__MvalidProperties$java_util_Properties) {
            return this.__M_validProperties(props);
        }
        try {
            this.__IM.onEntry((Object)this, "validProperties$java_util_Properties", new Object[]{props});
            bl = this.__M_validProperties(props);
            this.__IM.onExit((Object)this, "validProperties$java_util_Properties", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validProperties$java_util_Properties", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_validProperties(Properties props) {
        String jobName = props.getProperty(JOB_NAME, "");
        String appName = props.getProperty(APP_NAME, "");
        String cmdName = props.getProperty(CMD_NAME, "");
        String cron = props.getProperty(CRON, "");
        return !Utils.isEmptyOrWhitespaces((String)cron) && !Utils.isEmptyOrWhitespaces((String)jobName) && !Utils.isEmptyOrWhitespaces((String)appName) && !Utils.isEmptyOrWhitespaces((String)cmdName);
    }

    private void scheduleJob(Properties props) throws Exception {
        if (!this.__MscheduleJob$java_util_Properties) {
            this.__M_scheduleJob(props);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "scheduleJob$java_util_Properties", new Object[]{props});
            this.__M_scheduleJob(props);
            this.__IM.onExit((Object)this, "scheduleJob$java_util_Properties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "scheduleJob$java_util_Properties", throwable);
            throw throwable;
        }
    }

    private void __M_scheduleJob(Properties props) throws Exception {
        String jobId = props.getProperty(JOB_ID, "");
        String jobName = props.getProperty(JOB_NAME, "");
        String appName = props.getProperty(APP_NAME, "");
        String cmdName = props.getProperty(CMD_NAME, "");
        String cron = props.getProperty(CRON, "");
        JobDetail job = JobBuilder.newJob(CommandExecutionJob.class).withIdentity(jobId, appName).usingJobData(JOB_ID, jobId).usingJobData(APP_NAME, appName).usingJobData(JOB_NAME, jobName).usingJobData(CMD_NAME, cmdName).build();
        CronTrigger trigger = TriggerBuilder.newTrigger().withIdentity(jobId, appName).withSchedule(CronScheduleBuilder.cronSchedule(cron)).build();
        this.__getscheduler().scheduleJob(job, trigger);
    }

    private void unscheduleJob(String jobId) throws IOException {
        if (!this.__MunscheduleJob$java_lang_String) {
            this.__M_unscheduleJob(jobId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unscheduleJob$java_lang_String", new Object[]{jobId});
            this.__M_unscheduleJob(jobId);
            this.__IM.onExit((Object)this, "unscheduleJob$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unscheduleJob$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_unscheduleJob(String jobId) throws IOException {
        File f = this.getJobFile(jobId);
        try {
            Properties props;
            String appName;
            if (f.exists() && !Utils.isEmptyOrWhitespaces((String)(appName = (props = Utils.readPropertiesFileQuietly((File)f, (Logger)this.__getlogger())).getProperty(APP_NAME, "")))) {
                this.__getscheduler().unscheduleJob(TriggerKey.triggerKey(jobId, appName));
            }
        }
        catch (SchedulerException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                Utils.deleteFilesRecursively((File[])new File[]{f});
                throw throwable;
            }
        }
        Utils.deleteFilesRecursively((File[])new File[]{f});
    }

    private ScheduledJob from(Properties props) {
        ScheduledJob scheduledJob;
        if (!this.__Mfrom$java_util_Properties) {
            return this.__M_from(props);
        }
        try {
            this.__IM.onEntry((Object)this, "from$java_util_Properties", new Object[]{props});
            scheduledJob = this.__M_from(props);
            this.__IM.onExit((Object)this, "from$java_util_Properties", (Object)scheduledJob);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "from$java_util_Properties", throwable);
            throw throwable;
        }
        return scheduledJob;
    }

    private ScheduledJob __M_from(Properties props) {
        ScheduledJob job = new ScheduledJob(props.getProperty(JOB_ID));
        job.setAppName(props.getProperty(APP_NAME));
        job.setCmdName(props.getProperty(CMD_NAME));
        job.setJobName(props.getProperty(JOB_NAME));
        job.setCron(props.getProperty(CRON));
        return job;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("dmListener")) {
                this.__FdmListener = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains(MANAGER)) {
                this.__Fmanager = true;
            }
            if (set.contains(PROJECT_DIR_SCHEDULER)) {
                this.__Fscheduler = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("setManager$net_roboconf_dm_management_Manager")) {
                this.__MsetManager$net_roboconf_dm_management_Manager = true;
            }
            if (set.contains("loadJobs")) {
                this.__MloadJobs = true;
            }
            if (set.contains("listJobs")) {
                this.__MlistJobs = true;
            }
            if (set.contains("saveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MsaveJob$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("deleteJob$java_lang_String")) {
                this.__MdeleteJob$java_lang_String = true;
            }
            if (set.contains("findJobProperties$java_lang_String")) {
                this.__MfindJobProperties$java_lang_String = true;
            }
            if (set.contains("getSchedulerDirectory")) {
                this.__MgetSchedulerDirectory = true;
            }
            if (set.contains("getJobFile$java_lang_String")) {
                this.__MgetJobFile$java_lang_String = true;
            }
            if (set.contains("validProperties$java_util_Properties")) {
                this.__MvalidProperties$java_util_Properties = true;
            }
            if (set.contains("scheduleJob$java_util_Properties")) {
                this.__MscheduleJob$java_util_Properties = true;
            }
            if (set.contains("unscheduleJob$java_lang_String")) {
                this.__MunscheduleJob$java_lang_String = true;
            }
            if (set.contains("from$java_util_Properties")) {
                this.__Mfrom$java_util_Properties = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

