/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;

public final class KarafDmCommandsUtils {
    private KarafDmCommandsUtils() {
    }

    public static RbcfInfo findInstances(Manager manager, String applicationName, String scopedInstancePath, PrintStream out) {
        ManagedApplication ma = null;
        ArrayList<Instance> scopedInstances = new ArrayList<Instance>();
        ma = manager.applicationMngr().findManagedApplicationByName(applicationName);
        if (ma == null) {
            out.println("Unknown application: " + applicationName + ".");
        } else if (scopedInstancePath == null) {
            scopedInstances.addAll(InstanceHelpers.findAllScopedInstances((AbstractApplication)ma.getApplication()));
        } else {
            Instance scopedInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)scopedInstancePath);
            if (scopedInstance == null) {
                out.println("There is no " + scopedInstancePath + " instance in " + applicationName + ".");
            } else if (!InstanceHelpers.isTarget((Instance)scopedInstance)) {
                out.println("Instance " + scopedInstancePath + " is not a scoped instance in " + applicationName + ".");
            } else {
                scopedInstances.add(scopedInstance);
            }
        }
        return new RbcfInfo(scopedInstances, ma);
    }

    public static final class RbcfInfo {
        List<Instance> scopedInstances;
        ManagedApplication ma;

        private RbcfInfo(List<Instance> scopedInstances, ManagedApplication ma) {
            this.scopedInstances = scopedInstances;
            this.ma = ma;
        }

        public List<Instance> getScopedInstances() {
            return this.scopedInstances;
        }

        public ManagedApplication getManagedApplication() {
            return this.ma;
        }
    }
}

