/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm.diagnostics;

import java.io.PrintStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.events.IDmListener;
import net.roboconf.karaf.commands.dm.KarafDmCommandsUtils;
import net.roboconf.karaf.commands.dm.completers.ApplicationCompleter;
import net.roboconf.karaf.commands.dm.completers.ScopedInstanceCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="roboconf", name="diagnostic-messaging", description="Verifies messaging works")
@Service
public class DiagnosticMessagingCommand
implements Action {
    @Argument(index=0, name="application", description="The application's name", required=true, multiValued=false)
    @Completion(value=ApplicationCompleter.class)
    String applicationName;
    @Argument(index=1, name="scoped instance's path", description="The scoped instance's path", required=false, multiValued=false)
    @Completion(value=ScopedInstanceCompleter.class)
    String scopedInstancePath;
    @Reference
    Manager manager;
    final Logger logger = Logger.getLogger(this.getClass().getName());
    final Map<String, String> uuidToTarget = new ConcurrentHashMap<String, String>();
    final Map<String, Boolean> uuidToFound = new ConcurrentHashMap<String, Boolean>();
    PrintStream out = System.out;
    int waitingDelay = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        KarafDmCommandsUtils.RbcfInfo info = KarafDmCommandsUtils.findInstances(this.manager, this.applicationName, this.scopedInstancePath, this.out);
        if (!info.getScopedInstances().isEmpty()) {
            DiagnosticListener listener = new DiagnosticListener(this.uuidToFound);
            try {
                this.manager.listenerAppears((IDmListener)listener);
                this.out.println("Pinging the DM...");
                String uuid = UUID.randomUUID().toString();
                this.uuidToTarget.put(uuid, "The DM");
                this.manager.debugMngr().pingMessageQueue(uuid);
                for (Instance inst : info.getScopedInstances()) {
                    String path = InstanceHelpers.computeInstancePath((Instance)inst);
                    if (inst.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) {
                        this.out.println("Skipping agent " + path + " as it is not deployed and started.");
                        continue;
                    }
                    this.out.println("Pinging agent " + path);
                    uuid = UUID.randomUUID().toString();
                    this.uuidToTarget.put(uuid, "Agent " + path);
                    this.manager.debugMngr().pingAgent(info.getManagedApplication(), inst, uuid);
                }
                this.out.println("");
                this.out.println("Waiting few seconds to get PING results...");
                this.out.println("");
                Thread.sleep(this.waitingDelay * 1000);
            }
            finally {
                Boolean b;
                this.manager.listenerDisappears((IDmListener)listener);
                listener = null;
                this.out.println("");
                this.out.print("The " + this.waitingDelay + " second");
                if (this.waitingDelay > 1) {
                    this.out.print("s");
                }
                this.out.print(" delay elapsed.");
                this.out.println("");
                for (Map.Entry<String, String> entry : this.uuidToTarget.entrySet()) {
                    b = this.uuidToFound.get(entry.getKey());
                    if (b == null || !b.booleanValue()) continue;
                    this.out.println("[ SUCCESS ] " + entry.getValue() + " responded to the ping.");
                }
                this.out.println("");
                for (Map.Entry<String, String> entry : this.uuidToTarget.entrySet()) {
                    b = this.uuidToFound.get(entry.getKey());
                    if (b != null && b.booleanValue()) continue;
                    this.out.println("[ FAILURE ] " + entry.getValue() + " did not respond to the ping.");
                }
            }
        }
        return null;
    }

    static class DiagnosticListener
    implements IDmListener {
        Map<String, Boolean> uuidToFound;

        public DiagnosticListener(Map<String, Boolean> uuidToFound) {
            this.uuidToFound = uuidToFound;
        }

        public String getId() {
            return "karaf-command-to-diagnostic-messaging :: " + UUID.randomUUID().toString();
        }

        public void enableNotifications() {
        }

        public void disableNotifications() {
        }

        public void application(Application application, EventType eventType) {
        }

        public void applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
        }

        public void instance(Instance instance, Application application, EventType eventType) {
        }

        public void raw(String message, Object ... data) {
            String uuid = message.replaceFirst("^PONG:", "");
            this.uuidToFound.put(uuid, Boolean.TRUE);
        }
    }
}

