/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm.logs;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.Manager;
import net.roboconf.karaf.commands.dm.KarafDmCommandsUtils;
import net.roboconf.karaf.commands.dm.completers.ApplicationCompleter;
import net.roboconf.karaf.commands.dm.completers.LogLevelCompleter;
import net.roboconf.karaf.commands.dm.completers.ScopedInstanceCompleter;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdChangeLogLevel;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="roboconf", name="set-log-level", description="Changes the level of the Roboconf loggers for one or several agents")
@Service
public class ChangeLogLevelsCommand
implements Action {
    @Argument(index=0, name="log level", description="The log level (Java Logging)", required=true, multiValued=false)
    @Completion(value=LogLevelCompleter.class)
    String logLevelAsString;
    @Argument(index=1, name="application", description="The application's name", required=true, multiValued=false)
    @Completion(value=ApplicationCompleter.class)
    String applicationName;
    @Argument(index=2, name="scoped instance's path", description="The scoped instance's path", required=false, multiValued=false)
    @Completion(value=ScopedInstanceCompleter.class)
    String scopedInstancePath;
    @Reference
    Manager manager;
    final Logger logger = Logger.getLogger(this.getClass().getName());
    PrintStream out = System.out;

    public Object execute() throws Exception {
        boolean isValidLevel = true;
        Level logLevel = null;
        try {
            logLevel = Level.parse(this.logLevelAsString);
        }
        catch (Exception e) {
            Utils.logException((Logger)this.logger, (Throwable)e);
            isValidLevel = false;
        }
        if (!isValidLevel) {
            this.out.println("Invalid log level: " + this.logLevelAsString + ". Only  are allowed.");
            return null;
        }
        KarafDmCommandsUtils.RbcfInfo info = KarafDmCommandsUtils.findInstances(this.manager, this.applicationName, this.scopedInstancePath, this.out);
        for (Instance inst : info.getScopedInstances()) {
            StringBuilder sb;
            if (inst.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) {
                sb = new StringBuilder("No message will be sent to ");
                sb.append(this.scopedInstancePath);
                sb.append(", the associated agent is not marked as deployed.");
                this.out.println(sb.toString());
                continue;
            }
            if (this.logger.isLoggable(Level.FINE)) {
                sb = new StringBuilder("Sending a change log level message (level = ");
                sb.append(this.logLevelAsString);
                sb.append(") to ");
                sb.append(this.scopedInstancePath);
                sb.append(" @ ");
                sb.append(this.applicationName);
                this.logger.fine(sb.toString());
            }
            MsgCmdChangeLogLevel message = new MsgCmdChangeLogLevel(logLevel);
            this.manager.messagingMngr().sendMessageSafely(info.getManagedApplication(), inst, (Message)message);
        }
        return null;
    }
}

