/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm.targets;

import java.util.ArrayList;
import java.util.List;

public enum SupportedTarget {
    DOCKER,
    IN_MEMORY,
    OCCI,
    OPENSTACK,
    VMWARE,
    JCLOUDS,
    EC2,
    AZURE,
    EMBEDDED;


    public List<String> findString() {
        ArrayList<String> result = new ArrayList<String>();
        switch (this) {
            case EC2: {
                result.add("ec2");
                result.add("aws");
                result.add("amazon-web-services");
                break;
            }
            case AZURE: {
                result.add("azure");
                result.add("microsoft-azure");
                break;
            }
            case IN_MEMORY: {
                result.add("in-memory");
                break;
            }
            default: {
                result.add(super.toString().toLowerCase());
            }
        }
        return result;
    }

    public static List<String> allString() {
        ArrayList<String> result = new ArrayList<String>();
        for (SupportedTarget st : SupportedTarget.values()) {
            result.addAll(st.findString());
        }
        return result;
    }

    public static SupportedTarget which(String search) {
        SupportedTarget result = null;
        block0: for (SupportedTarget st : SupportedTarget.values()) {
            for (String s : st.findString()) {
                if (!s.equalsIgnoreCase(search)) continue;
                result = st;
                continue block0;
            }
        }
        return result;
    }

    public List<String> findCommands(String roboconfVersion) {
        ArrayList<String> result = new ArrayList<String>();
        switch (this) {
            case OPENSTACK: {
                result.add("feature:install jclouds-for-roboconf");
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-iaas-openstack/" + roboconfVersion);
                break;
            }
            case AZURE: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-iaas-azure/" + roboconfVersion);
                break;
            }
            case DOCKER: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-docker/" + roboconfVersion);
                break;
            }
            case EC2: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-iaas-ec2/" + roboconfVersion);
                break;
            }
            case EMBEDDED: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-embedded/" + roboconfVersion);
                break;
            }
            case IN_MEMORY: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-plugin-api/" + roboconfVersion);
                result.add("bundle:install --start mvn:net.roboconf/roboconf-agent/" + roboconfVersion);
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-in-memory/" + roboconfVersion);
                break;
            }
            case JCLOUDS: {
                result.add("feature:install jclouds-for-roboconf");
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-jclouds/" + roboconfVersion);
                break;
            }
            case VMWARE: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-iaas-vmware/" + roboconfVersion);
                break;
            }
            case OCCI: {
                result.add("bundle:install --start mvn:net.roboconf/roboconf-target-iaas-occi/" + roboconfVersion);
            }
        }
        return result;
    }
}

