/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.cors;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import net.roboconf.core.utils.Utils;

public class ResponseCorsFilter
implements ContainerResponseFilter {
    public static final String CORS_REQ_HEADERS = "Access-Control-Request-Headers";
    public static final String ORIGIN = "Origin";
    static final String CORS_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    static final String CORS_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String CORS_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    static final String CORS_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    static final String VALUE_ALLOWED_METHODS = "GET, DELETE, POST, PUT, OPTIONS";
    static final String VALUE_ALLOW_CREDENTIALS = "true";

    public ContainerResponse filter(ContainerRequest req, ContainerResponse contResp) {
        Response.ResponseBuilder resp = Response.fromResponse((Response)contResp.getResponse());
        Map<String, String> headers = ResponseCorsFilter.buildHeaders(req.getHeaderValue(CORS_REQ_HEADERS), req.getHeaderValue(ORIGIN));
        for (Map.Entry<String, String> h : headers.entrySet()) {
            resp.header(h.getKey(), (Object)h.getValue());
        }
        contResp.setResponse(resp.build());
        return contResp;
    }

    public static Map<String, String> buildHeaders(String reqCorsHeader, String requestUri) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(CORS_ALLOW_ORIGIN, requestUri);
        result.put(CORS_ALLOW_METHODS, VALUE_ALLOWED_METHODS);
        result.put(CORS_ALLOW_CREDENTIALS, VALUE_ALLOW_CREDENTIALS);
        if (!Utils.isEmptyOrWhitespaces((String)reqCorsHeader)) {
            result.put(CORS_ALLOW_HEADERS, reqCorsHeader);
        }
        return result;
    }
}

