/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.sun.jersey.api.core.DefaultResourceConfig;
import java.util.HashSet;
import java.util.Set;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.commons.json.ObjectMapperProvider;
import net.roboconf.dm.rest.commons.security.AuthenticationManager;
import net.roboconf.dm.rest.services.cors.ResponseCorsFilter;
import net.roboconf.dm.rest.services.internal.resources.IApplicationResource;
import net.roboconf.dm.rest.services.internal.resources.IDebugResource;
import net.roboconf.dm.rest.services.internal.resources.IHistoryResource;
import net.roboconf.dm.rest.services.internal.resources.IPreferencesResource;
import net.roboconf.dm.rest.services.internal.resources.ITargetResource;
import net.roboconf.dm.rest.services.internal.resources.impl.ApplicationResource;
import net.roboconf.dm.rest.services.internal.resources.impl.AuthenticationResource;
import net.roboconf.dm.rest.services.internal.resources.impl.DebugResource;
import net.roboconf.dm.rest.services.internal.resources.impl.HistoryResource;
import net.roboconf.dm.rest.services.internal.resources.impl.ManagementResource;
import net.roboconf.dm.rest.services.internal.resources.impl.PreferencesResource;
import net.roboconf.dm.rest.services.internal.resources.impl.SchedulerResource;
import net.roboconf.dm.rest.services.internal.resources.impl.TargetResource;
import net.roboconf.dm.scheduler.IScheduler;
import org.ops4j.pax.url.mvn.MavenResolver;

public class RestApplication
extends DefaultResourceConfig {
    private final IApplicationResource applicationResource;
    private final IDebugResource debugResource;
    private final ITargetResource targetResource;
    private final IPreferencesResource preferencesResource;
    private final IHistoryResource historyResource;
    private final ManagementResource managementResource;
    private final SchedulerResource schedulerResource;
    private final AuthenticationResource authenticationResource;

    public RestApplication(Manager manager) {
        this.applicationResource = new ApplicationResource(manager);
        this.managementResource = new ManagementResource(manager);
        this.debugResource = new DebugResource(manager);
        this.targetResource = new TargetResource(manager);
        this.preferencesResource = new PreferencesResource(manager);
        this.schedulerResource = new SchedulerResource(manager);
        this.authenticationResource = new AuthenticationResource(manager);
        this.historyResource = new HistoryResource(manager);
        this.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.getFeatures().put("com.sun.jersey.config.feature.DisableWADL", Boolean.TRUE);
    }

    public Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        result.add(ObjectMapperProvider.class);
        result.add(JacksonJsonProvider.class);
        return result;
    }

    public static Set<Class<?>> getResourceClasses() {
        HashSet result = new HashSet();
        result.add(ApplicationResource.class);
        result.add(ManagementResource.class);
        result.add(DebugResource.class);
        result.add(TargetResource.class);
        result.add(PreferencesResource.class);
        result.add(SchedulerResource.class);
        result.add(AuthenticationResource.class);
        result.add(HistoryResource.class);
        return result;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(this.applicationResource);
        set.add(this.managementResource);
        set.add(this.debugResource);
        set.add(this.targetResource);
        set.add(this.preferencesResource);
        set.add(this.schedulerResource);
        set.add(this.authenticationResource);
        set.add(this.historyResource);
        return set;
    }

    public void setScheduler(IScheduler scheduler) {
        this.schedulerResource.setScheduler(scheduler);
    }

    public void setMavenResolver(MavenResolver mavenResolver) {
        this.managementResource.setMavenResolver(mavenResolver);
    }

    public void setAuthenticationManager(AuthenticationManager authenticationMngr) {
        this.authenticationResource.setAuthenticationManager(authenticationMngr);
    }

    public void enableCors(boolean enableCors) {
        if (enableCors) {
            this.getProperties().put("com.sun.jersey.spi.container.ContainerResponseFilters", ResponseCorsFilter.class.getName());
        } else {
            this.getProperties().remove("com.sun.jersey.spi.container.ContainerResponseFilters");
        }
    }
}

