/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.errors.RoboconfError;
import net.roboconf.core.utils.Utils;

public class RestError
extends RoboconfError {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final String uuid = UUID.randomUUID().toString();
    private final Exception exception;

    public RestError(ErrorCode errorCode, ErrorDetails ... details) {
        this(errorCode, (Exception)null, details);
    }

    public RestError(ErrorCode errorCode, Exception e, ErrorDetails ... details) {
        super(errorCode);
        this.exception = e;
        this.setDetails(RestError.upgradeDetails(e, this.uuid, details));
        if (e != null) {
            Utils.logException((Logger)this.logger, (Level)Level.FINEST, (Throwable)e, (String)("Exception ID: " + this.uuid));
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.uuid, ((RestError)((Object)obj)).uuid);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static ErrorDetails[] upgradeDetails(Exception e, String uuid, ErrorDetails[] details) {
        ArrayList<ErrorDetails> list = new ArrayList<ErrorDetails>();
        if (details != null) {
            list.addAll(Arrays.asList(details));
        }
        if (e != null) {
            list.add(ErrorDetails.exceptionName((Throwable)e));
            list.add(ErrorDetails.logReference((String)uuid));
        }
        return list.toArray(new ErrorDetails[list.size()]);
    }
}

