/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.filters;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.rest.commons.security.AuthenticationManager;
import net.roboconf.dm.rest.services.cors.ResponseCorsFilter;
import net.roboconf.dm.rest.services.internal.ServletRegistrationComponent;
import net.roboconf.dm.rest.services.internal.annotations.RestIndexer;
import net.roboconf.dm.rest.services.internal.audit.AuditLogRecord;
import net.roboconf.dm.rest.services.jmx.RestServicesMBean;

public class AuthenticationFilter
implements Filter {
    static final String USER_AGENT = "User-Agent";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final RestServicesMBean restServicesMBean;
    private final RestIndexer restIndexer = new RestIndexer();
    private AuthenticationManager authenticationMngr;
    private boolean authenticationEnabled;
    private boolean enableCors;
    private long sessionPeriod;

    public AuthenticationFilter(RestServicesMBean restServicesMBean) {
        this.restServicesMBean = restServicesMBean;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        ((ServletRegistrationComponent)this.restServicesMBean).restRequestsCount.incrementAndGet();
        if (!this.authenticationEnabled) {
            chain.doFilter(req, resp);
        } else {
            boolean languagePreference;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            String requestedPath = request.getRequestURI();
            String restVerb = request.getMethod();
            String sessionId = null;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"roboconf-sid".equals(cookie.getName())) continue;
                    sessionId = cookie.getValue();
                    break;
                }
            }
            this.audit(request, sessionId);
            boolean loggedIn = false;
            if (!Utils.isEmptyOrWhitespaces(sessionId)) {
                loggedIn = this.authenticationMngr.isSessionValid(sessionId, this.sessionPeriod);
                this.logger.finest("Session " + sessionId + (loggedIn ? " was successfully " : " failed to be ") + "validated.");
            } else {
                this.logger.finest("No session ID was found in the cookie. Authentication cannot be performed.");
            }
            boolean loginRequest = requestedPath.endsWith("/auth/e");
            boolean optionsRequest = "options".equalsIgnoreCase(restVerb);
            boolean bl = languagePreference = requestedPath.endsWith("/preferences") && "get".equalsIgnoreCase(restVerb) && "key=user.language".equals(request.getQueryString());
            if (loggedIn || loginRequest || languagePreference || optionsRequest) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                if (this.enableCors) {
                    Map<String, String> headers = ResponseCorsFilter.buildHeaders(request.getHeader("Access-Control-Request-Headers"), request.getHeader("Origin"));
                    for (Map.Entry<String, String> h : headers.entrySet()) {
                        response.setHeader(h.getKey(), h.getValue());
                    }
                }
                ((ServletRegistrationComponent)this.restServicesMBean).restRequestsWithAuthFailureCount.incrementAndGet();
                response.sendError(403, "Authentication is required.");
            }
        }
    }

    private void audit(HttpServletRequest request, String sessionId) {
        boolean authorized;
        RestIndexer.RestOperationBean rightBean = null;
        String restVerb = request.getMethod();
        String uri = request.getRequestURI();
        String queryString = request.getQueryString();
        if (queryString != null) {
            uri = uri + "?" + queryString;
        }
        String path = AuthenticationFilter.cleanPath(uri);
        for (RestIndexer.RestOperationBean rmb : this.restIndexer.restMethods) {
            if (path == null || !path.matches(rmb.getUrlPattern()) || !rmb.getRestVerb().equalsIgnoreCase(restVerb)) continue;
            rightBean = rmb;
            break;
        }
        String ipAddress = request.getRemoteAddr();
        String userAgent = request.getHeader(USER_AGENT);
        String user = this.authenticationMngr.findUsername(sessionId);
        boolean bl = authorized = user != null;
        if (rightBean != null) {
            this.logger.log(new AuditLogRecord(user, rightBean.getJerseyPath(), uri, restVerb, ipAddress, userAgent, authorized));
        } else {
            this.logger.log(new AuditLogRecord(user, null, uri, restVerb, ipAddress, userAgent, authorized));
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationMngr) {
        this.authenticationMngr = authenticationMngr;
    }

    public void setSessionPeriod(long sessionPeriod) {
        this.sessionPeriod = sessionPeriod;
    }

    public void setEnableCors(boolean enableCors) {
        this.enableCors = enableCors;
    }

    static String cleanPath(String path) {
        return path.replaceFirst("^/roboconf-dm/", "/").replaceFirst("^/roboconf-dm-websocket/", "/").replaceFirst("\\?.*", "");
    }
}

