/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.dm.rest.commons.beans.TargetAssociation;

public interface IApplicationResource {
    public static final String PATH = "/app/{name}";

    @POST
    @Path(value="/change-state")
    public Response changeInstanceState(@PathParam(value="name") String var1, @QueryParam(value="new-state") String var2, @QueryParam(value="instance-path") String var3);

    @POST
    @Path(value="/description")
    public Response setDescription(@PathParam(value="name") String var1, String var2);

    @POST
    @Path(value="/deploy-all")
    public Response deployAndStartAll(@PathParam(value="name") String var1, @QueryParam(value="instance-path") String var2);

    @POST
    @Path(value="/stop-all")
    public Response stopAll(@PathParam(value="name") String var1, @QueryParam(value="instance-path") String var2);

    @POST
    @Path(value="/undeploy-all")
    public Response undeployAll(@PathParam(value="name") String var1, @QueryParam(value="instance-path") String var2);

    @POST
    @Path(value="/instances")
    @Consumes(value={"application/json"})
    public Response addInstance(@PathParam(value="name") String var1, @QueryParam(value="instance-path") String var2, Instance var3);

    @DELETE
    @Path(value="/instances")
    public Response removeInstance(@PathParam(value="name") String var1, @QueryParam(value="instance-path") String var2);

    @GET
    @Path(value="/targets")
    public List<TargetAssociation> findTargetAssociations(@PathParam(value="name") String var1);

    @POST
    @Path(value="/resynchronize")
    public Response resynchronize(@PathParam(value="name") String var1);

    @POST
    @Path(value="/bind")
    public Response bindApplication(@PathParam(value="name") String var1, @QueryParam(value="bound-tpl") String var2, @QueryParam(value="bound-app") String var3);

    @POST
    @Path(value="/unbind")
    public Response unbindApplication(@PathParam(value="name") String var1, @QueryParam(value="bound-tpl") String var2, @QueryParam(value="bound-app") String var3);

    @POST
    @Path(value="/bind-x")
    public Response replaceApplicationBindings(@PathParam(value="name") String var1, @QueryParam(value="bound-tpl") String var2, @QueryParam(value="app") List<String> var3);

    @GET
    @Path(value="/bind")
    public Response getApplicationBindings(@PathParam(value="name") String var1);

    @GET
    @Path(value="/instances")
    @Produces(value={"application/json"})
    public List<Instance> listChildrenInstances(@PathParam(value="name") String var1, @QueryParam(value="instance-path") String var2, @QueryParam(value="all-children") boolean var3);

    @GET
    @Path(value="/components")
    @Produces(value={"application/json"})
    public List<Component> listComponents(@PathParam(value="name") String var1);

    @GET
    @Path(value="/components/ancestors")
    @Produces(value={"application/json"})
    public List<Component> findComponentAncestors(@PathParam(value="name") String var1, @QueryParam(value="component-name") String var2);

    @GET
    @Path(value="/components/children")
    @Produces(value={"application/json"})
    public List<Component> findComponentChildren(@PathParam(value="name") String var1, @QueryParam(value="component-name") String var2);

    @GET
    @Path(value="/commands")
    public List<String> listCommands(@PathParam(value="name") String var1);

    @GET
    @Path(value="/commands/{command-name}")
    public Response getCommandInstructions(@PathParam(value="name") String var1, @PathParam(value="command-name") String var2);

    @POST
    @Path(value="/commands/execute")
    public Response executeCommand(@PathParam(value="name") String var1, @QueryParam(value="command-name") String var2);

    @POST
    @Path(value="/tags")
    public Response replaceTags(@PathParam(value="name") String var1, @QueryParam(value="version") String var2, @QueryParam(value="tags") List<String> var3);
}

