/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.roboconf.core.model.runtime.TargetUsageItem;
import net.roboconf.core.model.runtime.TargetWrapperDescriptor;

public interface ITargetResource {
    public static final String PATH = "/targets";

    @GET
    @Produces(value={"application/json"})
    public List<TargetWrapperDescriptor> listTargets(@QueryParam(value="name") String var1, @QueryParam(value="qualifier") String var2);

    @POST
    @Produces(value={"text/plain"})
    public Response createOrUpdateTarget(String var1, @QueryParam(value="target-id") String var2);

    @POST
    @Path(value="/archive")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response loadTargetArchive(@FormDataParam(value="file") InputStream var1, @FormDataParam(value="file") FormDataContentDisposition var2);

    @DELETE
    @Path(value="{target-id}")
    public Response deleteTarget(@PathParam(value="target-id") String var1);

    @GET
    @Path(value="{target-id}")
    public Response getTargetProperties(@PathParam(value="target-id") String var1);

    @GET
    @Path(value="{target-id}/details")
    public Response findTargetById(@PathParam(value="target-id") String var1);

    @Path(value="{target-id}/associations")
    @POST
    public Response associateTarget(@QueryParam(value="name") String var1, @QueryParam(value="qualifier") String var2, @QueryParam(value="elt") String var3, @PathParam(value="target-id") String var4, @QueryParam(value="bind") boolean var5);

    @Path(value="{target-id}/hints")
    @POST
    public Response updateHint(@QueryParam(value="name") String var1, @QueryParam(value="qualifier") String var2, @PathParam(value="target-id") String var3, @QueryParam(value="bind") boolean var4);

    @GET
    @Path(value="{target-id}/usage")
    @Produces(value={"application/json"})
    public List<TargetUsageItem> findUsageStatistics(@PathParam(value="target-id") String var1);
}

