/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.comparators.InstanceComparator;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.model.runtime.TargetWrapperDescriptor;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.exceptions.CommandException;
import net.roboconf.dm.management.exceptions.ImpossibleInsertionException;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;
import net.roboconf.dm.rest.commons.beans.ApplicationBindings;
import net.roboconf.dm.rest.commons.beans.TargetAssociation;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.IApplicationResource;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;
import net.roboconf.target.api.TargetException;

@Path(value="/app/{name}")
public class ApplicationResource
implements IApplicationResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;

    public ApplicationResource(Manager manager) {
        this.manager = manager;
    }

    @Override
    public Response changeInstanceState(String applicationName, String newState, String instancePath) {
        this.logger.fine("Request: change state of " + instancePath + " to '" + newState + "' in " + applicationName + ".");
        Response response = Response.ok().build();
        String lang = RestServicesUtils.lang(this.manager);
        try {
            if (!Instance.InstanceStatus.isValidState((String)newState)) {
                response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.name((String)newState)), lang).build();
            } else {
                ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
                if (ma == null) {
                    response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
                } else {
                    Instance instance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)instancePath);
                    if (instance == null) {
                        response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)instancePath), ErrorDetails.application((String)applicationName)), lang).build();
                    } else {
                        this.manager.instancesMngr().changeInstanceState(ma, instance, Instance.InstanceStatus.whichStatus((String)newState));
                    }
                }
            }
        }
        catch (IOException | TargetException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, (Exception)e, new ErrorDetails[0]), lang).build();
        }
        catch (Exception e) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response setDescription(String applicationName, String desc) {
        this.logger.fine("Request: change the description of " + applicationName + ".");
        Response response = Response.ok().build();
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.applicationMngr().updateApplication(ma, desc);
            }
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response deployAndStartAll(String applicationName, String instancePath) {
        Response response;
        this.logger.fine("Request: deploy and start instances in " + applicationName + ", from instance = " + instancePath + ".");
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            Instance instance = null;
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else if (instancePath != null && (instance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)instancePath)) == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)instancePath), ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.instancesMngr().deployAndStartAll(ma, instance);
                response = Response.ok().build();
            }
        }
        catch (Exception e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response stopAll(String applicationName, String instancePath) {
        Response response;
        this.logger.fine("Request: stop instances in " + applicationName + ", from instance = " + instancePath + ".");
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            Instance instance = null;
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else if (instancePath != null && (instance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)instancePath)) == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)instancePath), ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.instancesMngr().stopAll(ma, instance);
                response = Response.ok().build();
            }
        }
        catch (Exception e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response undeployAll(String applicationName, String instancePath) {
        Response response;
        this.logger.fine("Request: deploy and start instances in " + applicationName + ", from instance = " + instancePath + ".");
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            Instance instance = null;
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else if (instancePath != null && (instance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)instancePath)) == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)instancePath), ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.instancesMngr().undeployAll(ma, instance);
                response = Response.ok().build();
            }
        }
        catch (Exception e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public List<Instance> listChildrenInstances(String applicationName, String instancePath, boolean allChildren) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        Application app = this.manager.applicationMngr().findApplicationByName(applicationName);
        if (instancePath == null) {
            this.logger.fine("Request: list " + (allChildren ? "all" : "root") + " instances for " + applicationName + ".");
        } else {
            this.logger.fine("Request: list " + (allChildren ? "all" : "direct") + " children instances for " + instancePath + " in " + applicationName + ".");
        }
        if (app != null) {
            if (instancePath == null) {
                if (allChildren) {
                    result.addAll(InstanceHelpers.getAllInstances((AbstractApplication)app));
                } else {
                    result.addAll(app.getRootInstances());
                }
            } else {
                Instance inst = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePath);
                if (inst != null) {
                    if (allChildren) {
                        result.addAll(InstanceHelpers.buildHierarchicalList((Instance)inst));
                        result.remove(inst);
                    } else {
                        result.addAll(inst.getChildren());
                    }
                }
            }
        }
        Collections.sort(result, new InstanceComparator());
        return result;
    }

    @Override
    public Response bindApplication(String applicationName, String externalExportPrefix, String boundApp) {
        Response response;
        this.logger.fine("Binding " + boundApp + " to the " + externalExportPrefix + " prefix in application " + applicationName + ".");
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.applicationMngr().bindOrUnbindApplication(ma, externalExportPrefix, boundApp, true);
                response = Response.ok().build();
            }
        }
        catch (IOException | UnauthorizedActionException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, (Exception)e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response unbindApplication(String applicationName, String externalExportPrefix, String boundApp) {
        Response response;
        this.logger.fine("Unbinding " + boundApp + " from the " + externalExportPrefix + " prefix in application " + applicationName + ".");
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.applicationMngr().bindOrUnbindApplication(ma, externalExportPrefix, boundApp, false);
                response = Response.ok().build();
            }
        }
        catch (IOException | UnauthorizedActionException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, (Exception)e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response replaceApplicationBindings(String applicationName, String externalExportPrefix, List<String> boundApps) {
        Response response;
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Replacing the bindings for the ");
            sb.append(externalExportPrefix);
            sb.append(" prefix with ");
            sb.append(Arrays.toString(boundApps.toArray()));
            sb.append(" in application ");
            sb.append(applicationName);
            sb.append(".");
            this.logger.fine(sb.toString());
        }
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                TreeSet<String> apps = new TreeSet<String>();
                if (boundApps != null) {
                    apps.addAll(boundApps);
                }
                this.manager.applicationMngr().replaceApplicationBindings(ma, externalExportPrefix, apps);
                response = Response.ok().build();
            }
        }
        catch (IOException | UnauthorizedActionException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, (Exception)e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response getApplicationBindings(String applicationName) {
        Response response;
        ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
        if (ma == null) {
            response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), RestServicesUtils.lang(this.manager)).build();
        } else {
            ApplicationBindings bindings = new ApplicationBindings();
            for (Component c : ComponentHelpers.findAllComponents((AbstractApplication)ma.getApplication())) {
                for (ImportedVariable var : ComponentHelpers.findAllImportedVariables((Component)c).values()) {
                    if (!var.isExternal()) continue;
                    String prefix = (String)VariableHelpers.parseVariableName((String)var.getName()).getKey();
                    bindings.prefixToItems.put(prefix, new ArrayList());
                }
            }
            for (ManagedApplication managedApp : this.manager.applicationMngr().getManagedApplications()) {
                String prefix = managedApp.getApplication().getTemplate().getExternalExportsPrefix();
                if (prefix == null || !bindings.prefixToItems.containsKey(prefix)) continue;
                Set boundApps = (Set)ma.getApplication().getApplicationBindings().get(prefix);
                boolean bound = boundApps != null && boundApps.contains(managedApp.getName());
                ApplicationBindings.ApplicationBindingItem item = new ApplicationBindings.ApplicationBindingItem(managedApp.getName(), bound);
                ((List)bindings.prefixToItems.get(prefix)).add(item);
            }
            response = Response.ok().entity((Object)bindings).build();
        }
        return response;
    }

    @Override
    public Response addInstance(String applicationName, String parentInstancePath, Instance instance) {
        Response response;
        if (parentInstancePath == null) {
            this.logger.fine("Request: add root instance " + instance.getName() + " in " + applicationName + ".");
        } else {
            this.logger.fine("Request: add instance " + instance.getName() + " under " + parentInstancePath + " in " + applicationName + ".");
        }
        String lang = RestServicesUtils.lang(this.manager);
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                Graphs graphs = ma.getApplication().getTemplate().getGraphs();
                String componentName = null;
                if (instance.getComponent() != null) {
                    componentName = instance.getComponent().getName();
                }
                if (componentName == null) {
                    response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_MISSING_PROPERTY, ErrorDetails.value((String)"component")), lang).build();
                } else {
                    Component realComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)componentName);
                    if (realComponent == null) {
                        response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.component((String)componentName)), lang).build();
                    } else {
                        instance.setComponent(realComponent);
                        InstanceHelpers.fixOverriddenExports((Instance)instance);
                        Instance parentInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)parentInstancePath);
                        this.manager.instancesMngr().addInstance(ma, parentInstance, instance);
                        response = Response.ok().build();
                    }
                }
            }
        }
        catch (IOException | ImpossibleInsertionException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, (Exception)e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response removeInstance(String applicationName, String instancePath) {
        this.logger.fine("Request: remove " + instancePath + " in " + applicationName + ".");
        String lang = RestServicesUtils.lang(this.manager);
        Response response = Response.ok().build();
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                Instance instance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)instancePath);
                if (instance == null) {
                    response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)instancePath), ErrorDetails.application((String)applicationName)), lang).build();
                } else {
                    this.manager.instancesMngr().removeInstance(ma, instance);
                }
            }
        }
        catch (UnauthorizedActionException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_UNDETAILED_ERROR, (Exception)((Object)e), new ErrorDetails[0]), lang).build();
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.NOT_ACCEPTABLE, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public List<TargetAssociation> findTargetAssociations(String applicationName) {
        this.logger.fine("Request: find target associations in " + applicationName + ".");
        ArrayList<TargetAssociation> result = new ArrayList<TargetAssociation>();
        Application app = this.manager.applicationMngr().findApplicationByName(applicationName);
        if (app != null) {
            String targetId;
            String defaultTargetId = this.manager.targetsMngr().findTargetId((AbstractApplication)app, null);
            TargetWrapperDescriptor twd = null;
            if (defaultTargetId != null) {
                twd = this.manager.targetsMngr().findTargetById(defaultTargetId);
            }
            result.add(new TargetAssociation("", null, twd));
            for (Instance inst : InstanceHelpers.findAllScopedInstances((AbstractApplication)app)) {
                String instancePath = InstanceHelpers.computeInstancePath((Instance)inst);
                targetId = this.manager.targetsMngr().findTargetId((AbstractApplication)app, instancePath, true);
                twd = null;
                if (targetId != null) {
                    twd = this.manager.targetsMngr().findTargetById(targetId);
                }
                result.add(new TargetAssociation(instancePath, inst.getComponent().getName(), twd));
            }
            for (Component comp : ComponentHelpers.findAllComponents((AbstractApplication)app)) {
                if (!ComponentHelpers.isTarget((Component)comp)) continue;
                String key = "@" + comp.getName();
                targetId = this.manager.targetsMngr().findTargetId((AbstractApplication)app, key, true);
                twd = null;
                if (targetId != null) {
                    twd = this.manager.targetsMngr().findTargetById(targetId);
                }
                result.add(new TargetAssociation(key, null, twd));
            }
        }
        return result;
    }

    @Override
    public Response resynchronize(String applicationName) {
        this.logger.fine("Request: resynchronize all the agents.");
        String lang = RestServicesUtils.lang(this.manager);
        Response response = Response.ok().build();
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build();
            } else {
                this.manager.instancesMngr().resynchronizeAgents(ma);
            }
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.NOT_ACCEPTABLE, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public List<Component> listComponents(String applicationName) {
        this.logger.fine("Request: list components for the application " + applicationName + ".");
        ArrayList<Component> result = new ArrayList<Component>();
        Application app = this.manager.applicationMngr().findApplicationByName(applicationName);
        if (app != null) {
            result.addAll(ComponentHelpers.findAllComponents((AbstractApplication)app));
        }
        return result;
    }

    @Override
    public List<Component> findComponentChildren(String applicationName, String componentName) {
        if (componentName == null) {
            this.logger.fine("Request: list root components in " + applicationName + ".");
        } else {
            this.logger.fine("Request: find components that can be deployed under a " + componentName + " component in " + applicationName + ".");
        }
        ArrayList<Component> result = new ArrayList<Component>();
        Application app = this.manager.applicationMngr().findApplicationByName(applicationName);
        if (app != null) {
            if (componentName == null) {
                result.addAll(app.getTemplate().getGraphs().getRootComponents());
            } else {
                Component comp = ComponentHelpers.findComponent((AbstractApplication)app, (String)componentName);
                if (comp != null) {
                    result.addAll(ComponentHelpers.findAllChildren((Component)comp));
                } else {
                    this.logger.fine("No component called " + componentName + " was found in " + applicationName + ".");
                }
            }
        }
        return result;
    }

    @Override
    public List<Component> findComponentAncestors(String applicationName, String componentName) {
        this.logger.fine("Request: find components where a " + componentName + " component could be deployed on, in " + applicationName + ".");
        ArrayList<Component> result = new ArrayList<Component>();
        Application app = this.manager.applicationMngr().findApplicationByName(applicationName);
        if (app != null) {
            Component comp = ComponentHelpers.findComponent((Graphs)app.getTemplate().getGraphs(), (String)componentName);
            if (comp != null) {
                result.addAll(ComponentHelpers.findAllAncestors((Component)comp));
            } else {
                this.logger.fine("No component called " + componentName + " was found in " + applicationName + ".");
            }
        }
        return result;
    }

    @Override
    public List<String> listCommands(String app) {
        this.logger.fine("Request: list all the commands in the " + app + " application.");
        Application application = this.manager.applicationMngr().findApplicationByName(app);
        List result = application == null ? new ArrayList(0) : this.manager.commandsMngr().listCommands(application);
        return result;
    }

    @Override
    public Response executeCommand(String app, String commandName) {
        this.logger.fine("Request: execute command " + commandName + " in the " + app + " application.");
        String lang = RestServicesUtils.lang(this.manager);
        Response response = Response.ok().build();
        try {
            Application application = this.manager.applicationMngr().findApplicationByName(app);
            if (application == null) {
                response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)app)), lang).build();
            } else {
                this.manager.commandsMngr().execute(application, commandName, 2, null);
            }
        }
        catch (NoSuchFileException e) {
            response = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, e, ErrorDetails.name((String)commandName)), lang).build();
        }
        catch (CommandException e) {
            response = RestServicesUtils.handleError(Response.Status.CONFLICT, new RestError(ErrorCode.REST_APP_EXEC_ERROR, (Exception)((Object)e), ErrorDetails.name((String)commandName)), lang).build();
        }
        catch (Exception e) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), lang).build();
        }
        return response;
    }

    @Override
    public Response getCommandInstructions(String appName, String commandName) {
        Response response;
        this.logger.fine("Request: get instructions from " + commandName + " in the " + appName + " application.");
        try {
            String res;
            Application app = this.manager.applicationMngr().findApplicationByName(appName);
            response = app == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : (Utils.isEmptyOrWhitespaces((String)(res = this.manager.commandsMngr().getCommandInstructions(app, commandName))) ? Response.status((Response.Status)Response.Status.NO_CONTENT).build() : Response.ok((Object)res).build());
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_UNDETAILED_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    @Override
    public Response replaceTags(String name, String version, List<String> tags) {
        this.logger.fine("Request: replace tags for template " + name + " (version " + version + ").");
        Response response = Response.ok().build();
        ApplicationTemplate tpl = this.manager.applicationTemplateMngr().findTemplate(name, version);
        if (tpl == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        } else {
            tpl.setTags(tags);
        }
        return response;
    }
}

