/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.TargetValidator;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.runtime.TargetUsageItem;
import net.roboconf.core.model.runtime.TargetWrapperDescriptor;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.api.ITargetsMngr;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;
import net.roboconf.dm.rest.commons.json.StringWrapper;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.ITargetResource;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;

@Path(value="/targets")
public class TargetResource
implements ITargetResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;
    private final Map<Class<?>, Response.Status> exceptionclassToErrorCode;

    public TargetResource(Manager manager) {
        this.manager = manager;
        this.exceptionclassToErrorCode = new HashMap(2);
        this.exceptionclassToErrorCode.put(IOException.class, Response.Status.INTERNAL_SERVER_ERROR);
        this.exceptionclassToErrorCode.put(UnauthorizedActionException.class, Response.Status.FORBIDDEN);
    }

    @Override
    public List<TargetWrapperDescriptor> listTargets(String name, String qualifier) {
        StringBuilder sb = new StringBuilder("Request: list targets.");
        if (name != null) {
            sb.append(" Filter names: " + name);
            if (qualifier != null) {
                sb.append(", " + qualifier);
            }
        }
        this.logger.fine(sb.toString());
        AbstractApplication app = this.findAbstractApplication(name, qualifier);
        List result = app == null ? this.manager.targetsMngr().listAllTargets() : this.manager.targetsMngr().listPossibleTargets(app);
        return result;
    }

    @Override
    public Response createOrUpdateTarget(String rawProperties, String targetId) {
        Response response;
        if (targetId == null) {
            this.logger.fine("Request: create a new target.");
        } else {
            this.logger.fine("Request: update target " + targetId + ".");
        }
        String id = targetId;
        try {
            if (targetId == null) {
                id = this.manager.targetsMngr().createTarget(rawProperties);
            } else {
                this.manager.targetsMngr().updateTarget(targetId, rawProperties);
            }
            response = Response.ok().entity((Object)id).build();
        }
        catch (IOException | UnauthorizedActionException e) {
            Response.Status status = this.exceptionclassToErrorCode.get(e.getClass());
            response = RestServicesUtils.handleError(status, new RestError(ErrorCode.REST_SAVE_ERROR, (Exception)e, ErrorDetails.name((String)targetId)), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response loadTargetArchive(InputStream uploadedInputStream, FormDataContentDisposition fileDetail) {
        Response response;
        File dir;
        File tempZipFile;
        block9: {
            this.logger.fine("Request: load targets from an uploaded ZIP file (" + fileDetail.getFileName() + ").");
            tempZipFile = new File(System.getProperty("java.io.tmpdir"), fileDetail.getFileName());
            HashSet<String> newTargetIds = new HashSet<String>();
            dir = null;
            try {
                Utils.copyStream((InputStream)uploadedInputStream, (File)tempZipFile);
                String projectName = fileDetail.getFileName().replace(".zip", "");
                dir = new File(System.getProperty("java.io.tmpdir"), "roboconf/" + projectName);
                Utils.extractZipArchive((File)tempZipFile, (File)dir);
                List errors = TargetValidator.parseDirectory((File)dir);
                if (RoboconfErrorHelpers.containsCriticalErrors((Collection)errors)) {
                    response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_TARGET_CONTAINS_ERROR, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
                    break block9;
                }
                response = Response.ok().build();
                for (File f : Utils.listAllFiles((File)dir, (String)".properties")) {
                    String id = this.manager.targetsMngr().createTarget(f, null);
                    newTargetIds.add(id);
                }
            }
            catch (Exception e) {
                try {
                    response = RestServicesUtils.handleError(Response.Status.NOT_ACCEPTABLE, new RestError(ErrorCode.REST_IO_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
                    this.logger.fine("An error occurred while deploying targets. Unregistering those that were in the same archive.");
                    for (String id : newTargetIds) {
                        try {
                            this.manager.targetsMngr().deleteTarget(id);
                        }
                        catch (Exception e1) {
                            Utils.logException((Logger)this.logger, (Throwable)e1);
                            this.logger.severe("Target " + id + " could not be deleted.");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly((InputStream)uploadedInputStream);
                    Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{dir});
                    Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{tempZipFile});
                    throw throwable;
                }
                Utils.closeQuietly((InputStream)uploadedInputStream);
                Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{dir});
                Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{tempZipFile});
            }
        }
        Utils.closeQuietly((InputStream)uploadedInputStream);
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{dir});
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{tempZipFile});
        return response;
    }

    @Override
    public Response deleteTarget(String targetId) {
        this.logger.fine("Request: delete target " + targetId + ".");
        Response response = Response.ok().build();
        try {
            this.manager.targetsMngr().deleteTarget(targetId);
        }
        catch (IOException | UnauthorizedActionException e) {
            Response.Status status = this.exceptionclassToErrorCode.get(e.getClass());
            response = RestServicesUtils.handleError(status, new RestError(ErrorCode.REST_DELETION_ERROR, (Exception)e, ErrorDetails.name((String)targetId)), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    @Override
    public Response getTargetProperties(String targetId) {
        this.logger.fine("Request: get properties for target " + targetId + ".");
        ITargetsMngr.TargetProperties props = this.manager.targetsMngr().findTargetProperties(targetId);
        Response response = props.getSourceFile() == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok().entity((Object)new StringWrapper(props.asString())).build();
        return response;
    }

    @Override
    public Response findTargetById(String targetId) {
        this.logger.fine("Request: get details about target " + targetId + ".");
        TargetWrapperDescriptor twb = this.manager.targetsMngr().findTargetById(targetId);
        Response response = twb == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok().entity((Object)twb).build();
        return response;
    }

    @Override
    public Response associateTarget(String name, String qualifier, String instancePathOrComponentName, String targetId, boolean bind) {
        if (bind) {
            this.logger.fine("Request: associate " + instancePathOrComponentName + " with target " + targetId + ".");
        } else {
            this.logger.fine("Request: dissociate " + instancePathOrComponentName + " from its target.");
        }
        Response response = Response.ok().build();
        AbstractApplication app = this.findAbstractApplication(name, qualifier);
        try {
            if (app == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else if (bind) {
                this.manager.targetsMngr().associateTargetWith(targetId, app, instancePathOrComponentName);
            } else {
                this.manager.targetsMngr().dissociateTargetFrom(app, instancePathOrComponentName);
            }
        }
        catch (IOException | UnauthorizedActionException e) {
            Response.Status status = this.exceptionclassToErrorCode.get(e.getClass());
            response = RestServicesUtils.handleError(status, new RestError(ErrorCode.REST_TARGET_ASSOCIATION_ERROR, (Exception)e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    @Override
    public Response updateHint(String name, String qualifier, String targetId, boolean bind) {
        String id = name;
        if (qualifier != null) {
            id = id + " - " + qualifier;
        }
        if (bind) {
            this.logger.fine("Request: add a hint between " + id + " and target " + targetId + ".");
        } else {
            this.logger.fine("Request: remove a hint between " + id + " and target " + targetId + ".");
        }
        Response response = Response.ok().build();
        AbstractApplication app = this.findAbstractApplication(name, qualifier);
        try {
            if (app == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else if (bind) {
                this.manager.targetsMngr().addHint(targetId, app);
            } else {
                this.manager.targetsMngr().removeHint(targetId, app);
            }
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_TARGET_HINT_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    @Override
    public List<TargetUsageItem> findUsageStatistics(String targetId) {
        this.logger.fine("Request: list usage statistics for target " + targetId + ".");
        return this.manager.targetsMngr().findUsageStatistics(targetId);
    }

    private AbstractApplication findAbstractApplication(String name, String qualifier) {
        Object app = null;
        if (name != null) {
            app = qualifier != null ? this.manager.applicationTemplateMngr().findTemplate(name, qualifier) : this.manager.applicationMngr().findApplicationByName(name);
        }
        return app;
    }
}

