/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.events.IDmListener;
import net.roboconf.dm.rest.commons.beans.WebSocketMessage;
import net.roboconf.dm.rest.commons.json.JSonBindingUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.eclipse.jetty.websocket.api.Session;

public class WebSocketHandler
implements IDmListener,
Pojo {
    InstanceManager __IM;
    private static final Set<Session> SESSIONS = new HashSet<Session>();
    private boolean __Fenabled;
    private final AtomicBoolean enabled;
    private boolean __Flogger;
    private final Logger logger;
    boolean __MgetId;
    boolean __MenableNotifications;
    boolean __MdisableNotifications;
    boolean __Mapplication$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType;
    boolean __MapplicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType;
    boolean __Minstance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType;
    boolean __Mraw$java_lang_String$java_lang_Object__;
    boolean __MasJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage;
    boolean __Msend$java_lang_String;

    AtomicBoolean __getenabled() {
        if (!this.__Fenabled) {
            return this.enabled;
        }
        return (AtomicBoolean)this.__IM.onGet((Object)this, "enabled");
    }

    void __setenabled(AtomicBoolean atomicBoolean) {
        if (!this.__Fenabled) {
            this.enabled = atomicBoolean;
            return;
        }
        this.__IM.onSet((Object)this, "enabled", (Object)atomicBoolean);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public WebSocketHandler() {
        this(null);
    }

    private WebSocketHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setenabled(new AtomicBoolean(false));
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSession(Session session) {
        Set<Session> set = SESSIONS;
        synchronized (set) {
            SESSIONS.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSession(Session session) {
        Set<Session> set = SESSIONS;
        synchronized (set) {
            SESSIONS.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<Session> getSessions() {
        Set<Session> result;
        Set<Session> set = SESSIONS;
        synchronized (set) {
            result = Collections.unmodifiableSet(SESSIONS);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSessionsCount() {
        Set<Session> set = SESSIONS;
        synchronized (set) {
            return SESSIONS.size();
        }
    }

    public String getId() {
        String string;
        if (!this.__MgetId) {
            return this.__M_getId();
        }
        try {
            this.__IM.onEntry((Object)this, "getId", new Object[0]);
            string = this.__M_getId();
            this.__IM.onExit((Object)this, "getId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getId() {
        return "DM's Websocket";
    }

    public void enableNotifications() {
        if (!this.__MenableNotifications) {
            this.__M_enableNotifications();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "enableNotifications", new Object[0]);
            this.__M_enableNotifications();
            this.__IM.onExit((Object)this, "enableNotifications", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "enableNotifications", throwable);
            throw throwable;
        }
    }

    private void __M_enableNotifications() {
        this.__getenabled().set(true);
    }

    public void disableNotifications() {
        if (!this.__MdisableNotifications) {
            this.__M_disableNotifications();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "disableNotifications", new Object[0]);
            this.__M_disableNotifications();
            this.__IM.onExit((Object)this, "disableNotifications", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "disableNotifications", throwable);
            throw throwable;
        }
    }

    private void __M_disableNotifications() {
        this.__getenabled().set(false);
    }

    public void application(Application application, EventType eventType) {
        if (!this.__Mapplication$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType) {
            this.__M_application(application, eventType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", new Object[]{application, eventType});
            this.__M_application(application, eventType);
            this.__IM.onExit((Object)this, "application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", throwable);
            throw throwable;
        }
    }

    private void __M_application(Application application, EventType eventType) {
        WebSocketMessage message = new WebSocketMessage(application, eventType);
        String msg = this.asJson(message);
        this.send(msg);
    }

    public void applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
        if (!this.__MapplicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType) {
            this.__M_applicationTemplate(tpl, eventType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType", new Object[]{tpl, eventType});
            this.__M_applicationTemplate(tpl, eventType);
            this.__IM.onExit((Object)this, "applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType", throwable);
            throw throwable;
        }
    }

    private void __M_applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
        WebSocketMessage message = new WebSocketMessage(tpl, eventType);
        String msg = this.asJson(message);
        this.send(msg);
    }

    public void instance(Instance instance, Application application, EventType eventType) {
        if (!this.__Minstance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType) {
            this.__M_instance(instance, application, eventType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", new Object[]{instance, application, eventType});
            this.__M_instance(instance, application, eventType);
            this.__IM.onExit((Object)this, "instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", throwable);
            throw throwable;
        }
    }

    private void __M_instance(Instance instance, Application application, EventType eventType) {
        WebSocketMessage message = new WebSocketMessage(instance, application, eventType);
        String msg = this.asJson(message);
        this.send(msg);
    }

    public void raw(String message, Object ... data) {
        if (!this.__Mraw$java_lang_String$java_lang_Object__) {
            this.__M_raw(message, data);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "raw$java_lang_String$java_lang_Object__", new Object[]{message, data});
            this.__M_raw(message, data);
            this.__IM.onExit((Object)this, "raw$java_lang_String$java_lang_Object__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "raw$java_lang_String$java_lang_Object__", throwable);
            throw throwable;
        }
    }

    private void __M_raw(String message, Object[] data) {
        if (message != null) {
            WebSocketMessage wrappedMessage = new WebSocketMessage(message);
            String msg = this.asJson(wrappedMessage);
            this.send(msg);
        }
    }

    String asJson(WebSocketMessage message) {
        String string;
        if (!this.__MasJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage) {
            return this.__M_asJson(message);
        }
        try {
            this.__IM.onEntry((Object)this, "asJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage", new Object[]{message});
            string = this.__M_asJson(message);
            this.__IM.onExit((Object)this, "asJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "asJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_asJson(WebSocketMessage message) {
        String result = null;
        try {
            ObjectMapper mapper = JSonBindingUtils.createObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)message);
            result = writer.toString();
        }
        catch (IOException e) {
            this.__getlogger().severe("A notification could not be prepared. It will not be sent. " + e.getMessage());
            Utils.logException((Logger)this.__getlogger(), (Throwable)e);
        }
        return result;
    }

    private void send(String message) {
        if (!this.__Msend$java_lang_String) {
            this.__M_send(message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String", new Object[]{message});
            this.__M_send(message);
            this.__IM.onExit((Object)this, "send$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_send(String message) {
        if (!this.__getenabled().get()) {
            this.__getlogger().finest("Notifications were disabled by the DM.");
        } else if (message == null) {
            this.__getlogger().finest("No message to send to web socket clients.");
        } else {
            Set<Session> set = SESSIONS;
            synchronized (set) {
                for (Session session : SESSIONS) {
                    try {
                        this.__getlogger().finest("Sending a message to a web socket client...");
                        session.getRemote().sendString(message);
                    }
                    catch (IOException e) {
                        StringBuilder sb = new StringBuilder("A notification could not be propagated for session ");
                        sb.append(session.getRemoteAddress());
                        sb.append(".");
                        if (!Utils.isEmptyOrWhitespaces((String)e.getMessage())) {
                            sb.append(" " + e.getMessage());
                        }
                        this.__getlogger().severe(sb.toString());
                        Utils.logException((Logger)this.__getlogger(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("enabled")) {
                this.__Fenabled = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getId")) {
                this.__MgetId = true;
            }
            if (set.contains("enableNotifications")) {
                this.__MenableNotifications = true;
            }
            if (set.contains("disableNotifications")) {
                this.__MdisableNotifications = true;
            }
            if (set.contains("application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType")) {
                this.__Mapplication$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType = true;
            }
            if (set.contains("applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType")) {
                this.__MapplicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType = true;
            }
            if (set.contains("instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType")) {
                this.__Minstance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType = true;
            }
            if (set.contains("raw$java_lang_String$java_lang_Object__")) {
                this.__Mraw$java_lang_String$java_lang_Object__ = true;
            }
            if (set.contains("asJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage")) {
                this.__MasJson$net_roboconf_dm_rest_commons_beans_WebSocketMessage = true;
            }
            if (set.contains("send$java_lang_String")) {
                this.__Msend$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

