/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.pool.common.impl;

import javax.transaction.TransactionManager;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionManagerTracker
extends ServiceTracker<TransactionManager, ServiceRegistration> {
    private Logger LOG = LoggerFactory.getLogger(TransactionManager.class);
    private ServiceReference<TransactionManager> selectedService;

    public AbstractTransactionManagerTracker(BundleContext context) {
        super(context, TransactionManager.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration addingService(ServiceReference<TransactionManager> reference) {
        AbstractTransactionManagerTracker abstractTransactionManagerTracker = this;
        synchronized (abstractTransactionManagerTracker) {
            if (this.selectedService != null) {
                this.LOG.warn("There is more than one TransactionManager service. Ignoring this one");
                return null;
            }
            this.selectedService = reference;
        }
        this.LOG.info("TransactionManager service detected. Providing support for XA DataSourceFactories");
        TransactionManager tm = (TransactionManager)this.context.getService(reference);
        return this.createService(this.context, tm);
    }

    public void modifiedService(ServiceReference<TransactionManager> reference, ServiceRegistration sreg) {
        this.LOG.info("TransactionManager service modified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<TransactionManager> reference, ServiceRegistration sreg) {
        AbstractTransactionManagerTracker abstractTransactionManagerTracker = this;
        synchronized (abstractTransactionManagerTracker) {
            if (this.selectedService == null || !this.selectedService.equals(reference)) {
                return;
            }
            this.selectedService = null;
        }
        this.LOG.info("TransactionManager service lost. Shutting down support for XA DataSourceFactories");
        sreg.unregister();
        this.context.ungetService(reference);
    }

    public abstract ServiceRegistration<PooledDataSourceFactory> createService(BundleContext var1, TransactionManager var2);
}

