/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.prepare;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.roboconf.core.model.runtime.Preference;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.api.IPreferencesMngr;

public class GeneratePreferencesFile {
    public static void main(String[] args) {
        try {
            new GeneratePreferencesFile().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void run(String[] args) throws Exception {
        if (args.length != 1) {
            throw new RuntimeException("A file path was expected as an argument.");
        }
        File targetFile = new File(args[0]);
        if (!targetFile.isFile()) {
            throw new RuntimeException("File " + targetFile + " does not exist.");
        }
        Field[] fields = IPreferencesMngr.class.getDeclaredFields();
        HashMap<String, String> propertyNameToComment = new HashMap<String, String>();
        for (Field field : fields) {
            String constantName = (String)field.get(null);
            IPreferencesMngr.PreferenceDescription annotation = field.getAnnotation(IPreferencesMngr.PreferenceDescription.class);
            if (annotation == null) {
                throw new RuntimeException("Documentation was not written for the " + field.getName() + " constant in IPreferencesMngr.java.");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(annotation.desc());
            String[] values = annotation.values();
            if (values.length > 0) {
                sb.append("\n\nPossible values:\n");
                for (String value : values) {
                    sb.append(" - ");
                    sb.append(value);
                    sb.append("\n");
                }
            }
            propertyNameToComment.put(constantName, sb.toString());
        }
        IPreferencesMngr.Defaults def = new IPreferencesMngr.Defaults();
        StringBuilder sb = new StringBuilder();
        for (Preference.PreferenceKeyCategory cat : Preference.PreferenceKeyCategory.values()) {
            sb.append("\n###\n# ");
            sb.append(cat.getDescription());
            sb.append("\n###\n");
            for (Map.Entry entry : def.keyToCategory.entrySet()) {
                if (cat != entry.getValue()) continue;
                String comment = (String)propertyNameToComment.get(entry.getKey());
                comment = comment.replaceAll("^", "# ").replace("\n", "\n# ");
                sb.append("\n");
                sb.append(comment);
                sb.append("\n");
                sb.append((String)entry.getKey());
                sb.append(" = ");
                String defaultValue = (String)def.keyToDefaultValue.get(entry.getKey());
                if (!Utils.isEmptyOrWhitespaces((String)defaultValue)) {
                    sb.append(defaultValue.trim());
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        Utils.appendStringInto((String)sb.toString(), (File)targetFile);
    }
}

