/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.slf4j;

import java.util.Map;
import java.util.WeakHashMap;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.internal.FallbackLogFactory;
import org.ops4j.pax.logging.slf4j.Slf4jLogger;
import org.osgi.framework.BundleContext;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class Slf4jLoggerFactory
implements ILoggerFactory {
    private static PaxLoggingManager m_paxLogging;
    private static Map<String, Slf4jLogger> m_loggers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBundleContext(BundleContext context) {
        Map<String, Slf4jLogger> map = m_loggers;
        synchronized (map) {
            m_paxLogging = new OSGIPaxLoggingManager(context);
            for (Map.Entry<String, Slf4jLogger> entry : m_loggers.entrySet()) {
                String name = entry.getKey();
                Slf4jLogger logger = entry.getValue();
                logger.setPaxLoggingManager(m_paxLogging, name);
            }
            m_paxLogging.open();
        }
    }

    public static void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Logger getLogger(String name) {
        PaxLogger paxLogger = m_paxLogging == null ? FallbackLogFactory.createFallbackLog(null, name) : m_paxLogging.getLogger(name, Slf4jLogger.SLF4J_FQCN);
        Slf4jLogger logger = new Slf4jLogger(name, paxLogger);
        if (m_paxLogging == null) {
            Map<String, Slf4jLogger> map = m_loggers;
            synchronized (map) {
                m_loggers.put(name, logger);
            }
        }
        return logger;
    }

    public static void dispose() {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    static {
        m_loggers = new WeakHashMap<String, Slf4jLogger>();
    }
}

