/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.factory.IMessagingClientFactory;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.rabbitmq.internal.RabbitMqClient;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class RabbitMqClientFactory
implements IMessagingClientFactory,
Pojo {
    InstanceManager __IM;
    private boolean __Fconfiguration;
    Map<String, String> configuration;
    private boolean __Fclients;
    final Set<RabbitMqClient> clients;
    private boolean __Flogger;
    private final Logger logger;
    boolean __Mreconfigure;
    boolean __Mstop;
    boolean __MresetClients$boolean;
    boolean __MgetType;
    boolean __McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient;
    boolean __MsetConfiguration$java_util_Dictionary;
    boolean __MsetConfiguration$java_util_Map;

    Map __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (Map)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(Map map) {
        if (!this.__Fconfiguration) {
            this.configuration = map;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)map);
    }

    Set __getclients() {
        if (!this.__Fclients) {
            return this.clients;
        }
        return (Set)this.__IM.onGet((Object)this, "clients");
    }

    void __setclients(Set set) {
        if (!this.__Fclients) {
            this.clients = set;
            return;
        }
        this.__IM.onSet((Object)this, "clients", (Object)set);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public RabbitMqClientFactory() {
        this(null);
    }

    private RabbitMqClientFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setconfiguration(Collections.emptyMap());
        this.__setclients(Collections.newSetFromMap(new WeakHashMap()));
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public void reconfigure() {
        if (!this.__Mreconfigure) {
            this.__M_reconfigure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconfigure", new Object[0]);
            this.__M_reconfigure();
            this.__IM.onExit((Object)this, "reconfigure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconfigure", throwable);
            throw throwable;
        }
    }

    private void __M_reconfigure() {
        this.__getlogger().fine("Rabbit MQ clients are about to be reconfigured.");
        this.resetClients(false);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.resetClients(true);
    }

    private void resetClients(boolean shutdown) {
        if (!this.__MresetClients$boolean) {
            this.__M_resetClients(shutdown);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "resetClients$boolean", new Object[]{new Boolean(shutdown)});
            this.__M_resetClients(shutdown);
            this.__IM.onExit((Object)this, "resetClients$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resetClients$boolean", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_resetClients(boolean shutdown) {
        ArrayList clients;
        RabbitMqClientFactory rabbitMqClientFactory = this;
        synchronized (rabbitMqClientFactory) {
            clients = new ArrayList(this.__getclients());
            this.__getclients().clear();
        }
        for (RabbitMqClient client : clients) {
            try {
                ReconfigurableClient<?> reconfigurable = client.getReconfigurableClient();
                if (shutdown) {
                    reconfigurable.closeConnection();
                    continue;
                }
                reconfigurable.switchMessagingType("rabbitmq");
            }
            catch (Throwable t) {
                this.__getlogger().warning("A client has thrown an exception on reconfiguration: " + client);
                Utils.logException((Logger)this.__getlogger(), (Throwable)new RuntimeException(t));
            }
        }
    }

    public String getType() {
        String string;
        if (!this.__MgetType) {
            return this.__M_getType();
        }
        try {
            this.__IM.onEntry((Object)this, "getType", new Object[0]);
            string = this.__M_getType();
            this.__IM.onExit((Object)this, "getType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getType() {
        return "rabbitmq";
    }

    public IMessagingClient createClient(ReconfigurableClient<?> parent) {
        IMessagingClient iMessagingClient;
        if (!this.__McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient) {
            return this.__M_createClient(parent);
        }
        try {
            this.__IM.onEntry((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", new Object[]{parent});
            iMessagingClient = this.__M_createClient(parent);
            this.__IM.onExit((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", (Object)iMessagingClient);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", throwable);
            throw throwable;
        }
        return iMessagingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMessagingClient __M_createClient(ReconfigurableClient<?> parent) {
        this.__getlogger().fine("Creating a new Rabbit MQ client with owner = " + parent.getOwnerKind());
        RabbitMqClient client = new RabbitMqClient(parent, this.__getconfiguration());
        RabbitMqClientFactory rabbitMqClientFactory = this;
        synchronized (rabbitMqClientFactory) {
            this.__getclients().add(client);
        }
        this.__getlogger().finer("A new Rabbit MQ client was created.");
        return client;
    }

    public void setConfiguration(Dictionary<?, ?> properties) {
        if (!this.__MsetConfiguration$java_util_Dictionary) {
            this.__M_setConfiguration(properties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfiguration$java_util_Dictionary", new Object[]{properties});
            this.__M_setConfiguration(properties);
            this.__IM.onExit((Object)this, "setConfiguration$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfiguration$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_setConfiguration(Dictionary<?, ?> properties) {
        List<String> propertiesToSkip = Arrays.asList("component", "felix.fileinstall.filename");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration<?> en = properties.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            String keyAsString = String.valueOf(key);
            if (propertiesToSkip.contains(keyAsString)) continue;
            Object value = properties.get(key);
            map.put(keyAsString, String.valueOf(value));
        }
        map.put("net.roboconf.messaging.type", "rabbitmq");
        this.setConfiguration(map);
    }

    public boolean setConfiguration(Map<String, String> configuration) {
        boolean bl;
        if (!this.__MsetConfiguration$java_util_Map) {
            return this.__M_setConfiguration(configuration);
        }
        try {
            this.__IM.onEntry((Object)this, "setConfiguration$java_util_Map", new Object[]{configuration});
            bl = this.__M_setConfiguration(configuration);
            this.__IM.onExit((Object)this, "setConfiguration$java_util_Map", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfiguration$java_util_Map", throwable);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean __M_setConfiguration(Map<String, String> configuration) {
        boolean result = false;
        String type = configuration.get("net.roboconf.messaging.type");
        result = "rabbitmq".equals(type);
        if (result) {
            LinkedHashMap<String, String> configurationWithDefaults = new LinkedHashMap<String, String>();
            configurationWithDefaults.put("net.roboconf.messaging.rabbitmq.server.ip", "localhost");
            configurationWithDefaults.put("net.roboconf.messaging.rabbitmq.server.username", "guest");
            configurationWithDefaults.put("net.roboconf.messaging.rabbitmq.server.password", "guest");
            configurationWithDefaults.put("net.roboconf.messaging.rabbitmq.ssl.use", Boolean.FALSE.toString());
            configurationWithDefaults.putAll(configuration);
            boolean hasChanged = false;
            RabbitMqClientFactory rabbitMqClientFactory = this;
            synchronized (rabbitMqClientFactory) {
                for (Map.Entry configEntry : configurationWithDefaults.entrySet()) {
                    String value = (String)this.__getconfiguration().get(configEntry.getKey());
                    if (Objects.equals(value, configEntry.getValue())) continue;
                    hasChanged = true;
                    break;
                }
                if (hasChanged) {
                    this.__setconfiguration(configurationWithDefaults);
                    this.__getlogger().finer("Updating the messaging properties.");
                }
            }
            if (hasChanged) {
                this.reconfigure();
            }
        }
        return result;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("clients")) {
                this.__Fclients = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("reconfigure")) {
                this.__Mreconfigure = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("resetClients$boolean")) {
                this.__MresetClients$boolean = true;
            }
            if (set.contains("getType")) {
                this.__MgetType = true;
            }
            if (set.contains("createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient")) {
                this.__McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient = true;
            }
            if (set.contains("setConfiguration$java_util_Dictionary")) {
                this.__MsetConfiguration$java_util_Dictionary = true;
            }
            if (set.contains("setConfiguration$java_util_Map")) {
                this.__MsetConfiguration$java_util_Map = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

