/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.rabbitmq.internal.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.utils.SerializationUtils;

public class RoboconfConsumer
extends DefaultConsumer
implements Consumer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final RoboconfMessageQueue messageQueue;
    private final String sourceName;

    public RoboconfConsumer(String sourceName, Channel channel, RoboconfMessageQueue messageQueue) {
        super(channel);
        this.messageQueue = messageQueue;
        this.sourceName = sourceName;
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        try {
            Message message = SerializationUtils.deserializeObject((byte[])body);
            this.logger.finer(this.sourceName + " received a message " + message.getClass().getSimpleName() + " on routing key '" + envelope.getRoutingKey() + "'.");
            this.messageQueue.add((Object)message);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.severe(this.sourceName + ": a message could not be deserialized. => " + e.getClass().getSimpleName());
            Utils.logException((Logger)this.logger, (Throwable)e);
            this.messageQueue.errorWhileReceivingMessage();
        }
    }

    @Override
    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        if (sig.isInitiatedByApplication()) {
            this.logger.fine(this.sourceName + ": the connection to the messaging server was shut down." + this.id(consumerTag));
        } else if (sig.getReference() instanceof Channel) {
            int nb = ((Channel)sig.getReference()).getChannelNumber();
            this.logger.fine("A RabbitMQ consumer was shut down. Channel #" + nb + ", " + this.id(consumerTag));
        } else {
            this.logger.fine("A RabbitMQ consumer was shut down." + this.id(consumerTag));
        }
    }

    @Override
    public void handleCancelOk(String consumerTag) {
        this.logger.fine("A RabbitMQ consumer stops listening to new messages." + this.id(consumerTag));
    }

    @Override
    public void handleCancel(String consumerTag) throws IOException {
        this.logger.fine("A RabbitMQ consumer UNEXPECTABLY stops listening to new messages." + this.id(consumerTag));
    }

    private String id(String consumerTag) {
        StringBuilder sb = new StringBuilder();
        sb.append(" Consumer tag = ");
        sb.append(consumerTag);
        sb.append(" (@ ");
        sb.append(this.sourceName);
        sb.append(")");
        return sb.toString();
    }
}

