/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.factory;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.factory.IMessagingClientFactory;
import net.roboconf.messaging.api.factory.MessagingClientFactoryListener;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class MessagingClientFactoryRegistry
implements Pojo {
    InstanceManager __IM;
    private boolean __Ffactories;
    private final ConcurrentHashMap<String, IMessagingClientFactory> factories;
    private boolean __Flisteners;
    private final ConcurrentLinkedQueue<MessagingClientFactoryListener> listeners;
    private boolean __Flogger;
    private final Logger logger;
    boolean __MgetMessagingClientFactory$java_lang_String;
    boolean __MaddMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory;
    boolean __MremoveMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory;
    boolean __MaddListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener;
    boolean __MremoveListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener;
    boolean __MnotifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean;

    ConcurrentHashMap __getfactories() {
        if (!this.__Ffactories) {
            return this.factories;
        }
        return (ConcurrentHashMap)this.__IM.onGet((Object)this, "factories");
    }

    void __setfactories(ConcurrentHashMap concurrentHashMap) {
        if (!this.__Ffactories) {
            this.factories = concurrentHashMap;
            return;
        }
        this.__IM.onSet((Object)this, "factories", (Object)concurrentHashMap);
    }

    ConcurrentLinkedQueue __getlisteners() {
        if (!this.__Flisteners) {
            return this.listeners;
        }
        return (ConcurrentLinkedQueue)this.__IM.onGet((Object)this, "listeners");
    }

    void __setlisteners(ConcurrentLinkedQueue concurrentLinkedQueue) {
        if (!this.__Flisteners) {
            this.listeners = concurrentLinkedQueue;
            return;
        }
        this.__IM.onSet((Object)this, "listeners", (Object)concurrentLinkedQueue);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    public MessagingClientFactoryRegistry() {
        this(null);
    }

    private MessagingClientFactoryRegistry(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setfactories(new ConcurrentHashMap());
        this.__setlisteners(new ConcurrentLinkedQueue());
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public IMessagingClientFactory getMessagingClientFactory(String type) {
        IMessagingClientFactory iMessagingClientFactory;
        if (!this.__MgetMessagingClientFactory$java_lang_String) {
            return this.__M_getMessagingClientFactory(type);
        }
        try {
            this.__IM.onEntry((Object)this, "getMessagingClientFactory$java_lang_String", new Object[]{type});
            iMessagingClientFactory = this.__M_getMessagingClientFactory(type);
            this.__IM.onExit((Object)this, "getMessagingClientFactory$java_lang_String", (Object)iMessagingClientFactory);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMessagingClientFactory$java_lang_String", throwable);
            throw throwable;
        }
        return iMessagingClientFactory;
    }

    private IMessagingClientFactory __M_getMessagingClientFactory(String type) {
        IMessagingClientFactory result = null;
        if (type != null) {
            result = (IMessagingClientFactory)this.__getfactories().get(type);
        }
        return result;
    }

    public boolean addMessagingClientFactory(IMessagingClientFactory factory) {
        boolean bl;
        if (!this.__MaddMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory) {
            return this.__M_addMessagingClientFactory(factory);
        }
        try {
            this.__IM.onEntry((Object)this, "addMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory", new Object[]{factory});
            bl = this.__M_addMessagingClientFactory(factory);
            this.__IM.onExit((Object)this, "addMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_addMessagingClientFactory(IMessagingClientFactory factory) {
        boolean result;
        String type = factory.getType();
        this.__getlogger().fine("Adding messaging client factory: " + type);
        boolean bl = result = this.__getfactories().putIfAbsent(type, factory) == null;
        if (result) {
            this.notifyListeners(factory, true);
        }
        return result;
    }

    public boolean removeMessagingClientFactory(IMessagingClientFactory factory) {
        boolean bl;
        if (!this.__MremoveMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory) {
            return this.__M_removeMessagingClientFactory(factory);
        }
        try {
            this.__IM.onEntry((Object)this, "removeMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory", new Object[]{factory});
            bl = this.__M_removeMessagingClientFactory(factory);
            this.__IM.onExit((Object)this, "removeMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_removeMessagingClientFactory(IMessagingClientFactory factory) {
        String type = factory.getType();
        this.__getlogger().fine("Removing messaging client factory: " + type);
        boolean result = this.__getfactories().remove(type, factory);
        if (result) {
            this.notifyListeners(factory, false);
        }
        return result;
    }

    public void addListener(MessagingClientFactoryListener listener) {
        if (!this.__MaddListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener) {
            this.__M_addListener(listener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener", new Object[]{listener});
            this.__M_addListener(listener);
            this.__IM.onExit((Object)this, "addListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener", throwable);
            throw throwable;
        }
    }

    private void __M_addListener(MessagingClientFactoryListener listener) {
        this.__getlisteners().add(listener);
    }

    public void removeListener(MessagingClientFactoryListener listener) {
        if (!this.__MremoveListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener) {
            this.__M_removeListener(listener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener", new Object[]{listener});
            this.__M_removeListener(listener);
            this.__IM.onExit((Object)this, "removeListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener", throwable);
            throw throwable;
        }
    }

    private void __M_removeListener(MessagingClientFactoryListener listener) {
        this.__getlisteners().remove(listener);
    }

    private void notifyListeners(IMessagingClientFactory factory, boolean isAdded) {
        if (!this.__MnotifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean) {
            this.__M_notifyListeners(factory, isAdded);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "notifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean", new Object[]{factory, new Boolean(isAdded)});
            this.__M_notifyListeners(factory, isAdded);
            this.__IM.onExit((Object)this, "notifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "notifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_notifyListeners(IMessagingClientFactory factory, boolean isAdded) {
        for (MessagingClientFactoryListener listener : this.__getlisteners()) {
            try {
                if (isAdded) {
                    listener.addMessagingClientFactory(factory);
                    continue;
                }
                listener.removeMessagingClientFactory(factory);
            }
            catch (Throwable t) {
                this.__getlogger().warning("Messaging client factory listener has thrown an exception: " + listener);
                Utils.logException((Logger)this.__getlogger(), (Throwable)new RuntimeException(t));
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("factories")) {
                this.__Ffactories = true;
            }
            if (set.contains("listeners")) {
                this.__Flisteners = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getMessagingClientFactory$java_lang_String")) {
                this.__MgetMessagingClientFactory$java_lang_String = true;
            }
            if (set.contains("addMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory")) {
                this.__MaddMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory = true;
            }
            if (set.contains("removeMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory")) {
                this.__MremoveMessagingClientFactory$net_roboconf_messaging_api_factory_IMessagingClientFactory = true;
            }
            if (set.contains("addListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener")) {
                this.__MaddListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener = true;
            }
            if (set.contains("removeListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener")) {
                this.__MremoveListener$net_roboconf_messaging_api_factory_MessagingClientFactoryListener = true;
            }
            if (set.contains("notifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean")) {
                this.__MnotifyListeners$net_roboconf_messaging_api_factory_IMessagingClientFactory$boolean = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

