/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.internal.client.in_memory;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.roboconf.messaging.api.extensions.AbstractRoutingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;

public class InMemoryClient
extends AbstractRoutingClient<LinkedBlockingQueue<Message>> {
    private final Map<String, LinkedBlockingQueue<Message>> ctxToQueue;

    public InMemoryClient(InMemoryRoutingContext routingContext, MessagingContext.RecipientKind ownerKind) {
        super(routingContext, ownerKind);
        this.ctxToQueue = routingContext.ctxToQueue;
    }

    @Override
    public void setMessageQueue(RoboconfMessageQueue messageQueue) {
        this.ctxToQueue.put(this.ownerId, messageQueue);
    }

    @Override
    protected Map<String, LinkedBlockingQueue<Message>> getStaticContextToObject() {
        return this.ctxToQueue;
    }

    @Override
    public String getMessagingType() {
        return "in-memory";
    }

    @Override
    protected void process(LinkedBlockingQueue<Message> queue, Message message) throws IOException {
        queue.add(message);
    }

    public static class InMemoryRoutingContext
    extends AbstractRoutingClient.RoutingContext {
        public final Map<String, LinkedBlockingQueue<Message>> ctxToQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<Message>>();
    }
}

