/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.internal.jmx;

import java.io.IOException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.internal.client.dismiss.DismissClient;
import net.roboconf.messaging.api.jmx.MessagingApiMBean;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.utils.MessagingUtils;
import net.roboconf.messaging.api.utils.OsgiHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class JmxWrapperForMessagingClient
implements IMessagingClient,
MessagingApiMBean {
    private final AtomicLong sentMessagesCount = new AtomicLong();
    private final AtomicLong failedSendingCount = new AtomicLong();
    private final AtomicLong timestampOfLastSendingFailure = new AtomicLong();
    private final AtomicLong timestampOfLastSentMessage = new AtomicLong();
    private final IMessagingClient messagingClient;
    private RoboconfMessageQueue messageQueue;
    private String id;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    ServiceRegistration<MessagingApiMBean> serviceReg;

    public JmxWrapperForMessagingClient(IMessagingClient messagingClient) {
        this(messagingClient, new OsgiHelper());
    }

    JmxWrapperForMessagingClient(IMessagingClient messagingClient, OsgiHelper osgiHelper) {
        this.messagingClient = messagingClient != null ? messagingClient : new DismissClient();
        BundleContext bundleCtx = osgiHelper.findBundleContext();
        if (bundleCtx != null) {
            this.logger.fine("Running in an OSGi environment. Trying to register a MBean for the messaging.");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("jmx.objectname", "net.roboconf:type=messaging");
            try {
                this.serviceReg = bundleCtx.registerService(MessagingApiMBean.class, (Object)this, properties);
                this.logger.fine("A MBean was successfully registered for the messaging.");
            }
            catch (Exception e) {
                this.logger.severe("A MBean could not be registered for the messaging.");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }

    public void unregisterService() {
        try {
            if (this.serviceReg != null) {
                this.logger.finer("Running in an OSGi environment. Trying to unregister a MBean for the messaging.");
                this.serviceReg.unregister();
                this.logger.finer("Running in an OSGi environment. The MBean was unregistered.");
            }
        }
        catch (Exception e) {
            this.logger.severe("A MBean could not be unregistered for the messaging.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        finally {
            this.serviceReg = null;
        }
    }

    public boolean isDismissClient() {
        return this.messagingClient instanceof DismissClient;
    }

    @Override
    public synchronized void reset() {
        this.sentMessagesCount.set(0L);
        this.failedSendingCount.set(0L);
        this.timestampOfLastSendingFailure.set(0L);
        this.timestampOfLastSentMessage.set(0L);
        if (this.messageQueue != null) {
            this.messageQueue.reset();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public synchronized long getFailedSendingCount() {
        return this.failedSendingCount.get();
    }

    @Override
    public synchronized long getSentMessagesCount() {
        return this.sentMessagesCount.get();
    }

    @Override
    public synchronized long getTimestampOfLastSendingFailure() {
        return this.timestampOfLastSendingFailure.get();
    }

    @Override
    public synchronized long getTimestampOfLastSentMessage() {
        return this.timestampOfLastSentMessage.get();
    }

    @Override
    public synchronized long getFailedReceptionCount() {
        return this.messageQueue == null ? 0L : this.messageQueue.getFailedReceptionCount();
    }

    @Override
    public synchronized long getReceivedMessagesCount() {
        return this.messageQueue == null ? 0L : this.messageQueue.getReceivedMessagesCount();
    }

    @Override
    public synchronized long getTimestampOfLastReceptionFailure() {
        return this.messageQueue == null ? 0L : this.messageQueue.getTimestampOfLastReceptionFailure();
    }

    @Override
    public synchronized long getTimestampOfLastReceivedMessage() {
        return this.messageQueue == null ? 0L : this.messageQueue.getTimestampOfLastReceivedMessage();
    }

    @Override
    public void closeConnection() throws IOException {
        this.messagingClient.closeConnection();
    }

    @Override
    public void openConnection() throws IOException {
        this.messagingClient.openConnection();
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        this.messagingClient.deleteMessagingServerArtifacts(application);
    }

    @Override
    public Map<String, String> getConfiguration() {
        return this.messagingClient.getConfiguration();
    }

    @Override
    public String getMessagingType() {
        return this.messagingClient.getMessagingType();
    }

    @Override
    public boolean isConnected() {
        return this.messagingClient.isConnected();
    }

    @Override
    public void subscribe(MessagingContext ctx) throws IOException {
        this.messagingClient.subscribe(ctx);
    }

    @Override
    public void unsubscribe(MessagingContext ctx) throws IOException {
        this.messagingClient.unsubscribe(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageQueue(RoboconfMessageQueue messageQueue) {
        JmxWrapperForMessagingClient jmxWrapperForMessagingClient = this;
        synchronized (jmxWrapperForMessagingClient) {
            this.messageQueue = messageQueue;
        }
        this.messagingClient.setMessageQueue(messageQueue);
    }

    @Override
    public void publish(MessagingContext ctx, Message msg) throws IOException {
        try {
            this.messagingClient.publish(ctx, msg);
            this.sentMessagesCount.incrementAndGet();
            this.timestampOfLastSentMessage.set(new Date().getTime());
        }
        catch (IOException e) {
            this.failedSendingCount.incrementAndGet();
            this.timestampOfLastSendingFailure.set(new Date().getTime());
            throw e;
        }
    }

    @Override
    public void setOwnerProperties(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
        this.id = MessagingUtils.buildId(ownerKind, domain, applicationName, scopedInstancePath);
        this.messagingClient.setOwnerProperties(ownerKind, domain, applicationName, scopedInstancePath);
    }
}

