/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.jmx;

import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.roboconf.messaging.api.messages.Message;

public class RoboconfMessageQueue
extends LinkedBlockingQueue<Message> {
    private static final long serialVersionUID = 6728334259953445852L;
    private final AtomicLong receivedMessagesCount = new AtomicLong();
    private final AtomicLong timestampOfLastReceivedMessage = new AtomicLong();
    private final AtomicLong failedReceptionCount = new AtomicLong();
    private final AtomicLong timestampOfLastReceptionFailure = new AtomicLong();

    public RoboconfMessageQueue() {
    }

    RoboconfMessageQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(Message e) {
        boolean result = super.offer(e);
        if (result) {
            this.receivedMessagesCount.incrementAndGet();
            this.timestampOfLastReceivedMessage.set(new Date().getTime());
        }
        return result;
    }

    @Override
    public void put(Message e) throws InterruptedException {
        throw new RuntimeException("This method is disabled for Roboconf.");
    }

    public void reset() {
        this.receivedMessagesCount.set(0L);
        this.timestampOfLastReceivedMessage.set(0L);
        this.failedReceptionCount.set(0L);
        this.timestampOfLastReceptionFailure.set(0L);
    }

    public void errorWhileReceivingMessage() {
        this.failedReceptionCount.incrementAndGet();
        this.timestampOfLastReceptionFailure.set(new Date().getTime());
    }

    public long getFailedReceptionCount() {
        return this.failedReceptionCount.get();
    }

    public long getReceivedMessagesCount() {
        return this.receivedMessagesCount.get();
    }

    public long getTimestampOfLastReceptionFailure() {
        return this.timestampOfLastReceptionFailure.get();
    }

    public long getTimestampOfLastReceivedMessage() {
        return this.timestampOfLastReceivedMessage.get();
    }
}

