/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.utils;

import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.MessagingContext;

public final class MessagingUtils {
    private MessagingUtils() {
    }

    public static String buildTopicNameForAgent(Instance instance) {
        Instance scopedInstance = InstanceHelpers.findScopedInstance((Instance)instance);
        return MessagingUtils.buildTopicNameForAgent(InstanceHelpers.computeInstancePath((Instance)scopedInstance));
    }

    public static String buildTopicNameForAgent(String scopedInstancePath) {
        return "machine." + MessagingUtils.escapeInstancePath(scopedInstancePath);
    }

    public static String escapeInstancePath(String instancePath) {
        String result = Utils.isEmptyOrWhitespaces((String)instancePath) ? "" : instancePath.replaceFirst("^/*", "").replaceFirst("/*$", "").replaceAll("/+", ".");
        return result;
    }

    public static String buildId(MessagingContext.RecipientKind ownerKind, String domain, String applicationName, String scopedInstancePath) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        sb.append(domain);
        sb.append(" ] ");
        if (ownerKind == MessagingContext.RecipientKind.DM) {
            sb.append("DM");
        } else {
            sb.append(scopedInstancePath);
            sb.append(" @ ");
            sb.append(applicationName);
        }
        return sb.toString();
    }
}

