/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.commons.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.model.runtime.CommandHistoryItem;
import net.roboconf.core.model.runtime.Preference;
import net.roboconf.core.model.runtime.ScheduledJob;
import net.roboconf.core.model.runtime.TargetUsageItem;
import net.roboconf.core.model.runtime.TargetWrapperDescriptor;
import net.roboconf.core.utils.IconUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.rest.commons.Diagnostic;
import net.roboconf.dm.rest.commons.beans.ApplicationBindings;
import net.roboconf.dm.rest.commons.beans.TargetAssociation;
import net.roboconf.dm.rest.commons.beans.WebSocketMessage;
import net.roboconf.dm.rest.commons.json.MapWrapper;
import net.roboconf.dm.rest.commons.json.MappedCollectionWrapper;
import net.roboconf.dm.rest.commons.json.StringWrapper;

public final class JSonBindingUtils {
    public static final String AT_INSTANCE_PATH = "@instance_path";
    static final Map<Class<?>, JsonSerializer<?>> SERIALIZERS = new HashMap();
    static final Map<Class<?>, JsonDeserializer<?>> DESERIALIZERS = new HashMap();
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String VERSION = "version";
    private static final String DESC = "desc";
    private static final String EEP = "eep";
    private static final String EXT_VARS = "extVars";
    private static final String EXT_DEP = "extDep";
    private static final String S = "s";
    private static final String PATH = "path";
    private static final String CRON = "cron";
    private static final String ID = "id";
    private static final String BOUND = "bound";
    private static final String APP_ICON = "icon";
    private static final String APP_INFO = "info";
    private static final String APP_INST_TPL_NAME = "tplName";
    private static final String APP_INST_TPL_VERSION = "tplVersion";
    private static final String APP_INST_TPL_EEP = "tplEep";
    private static final String APP_TPL_APPS = "apps";
    private static final String APP_TPL_TAGS = "tags";
    private static final String COMP_INSTALLER = "installer";
    private static final String INST_CHANNELS = "channels";
    private static final String INST_COMPONENT = "component";
    private static final String INST_STATUS = "status";
    private static final String INST_EXPORTS = "exports";
    private static final String INST_DATA = "data";
    private static final String DEP_OPTIONAL = "optional";
    private static final String DEP_RESOLVED = "resolved";
    private static final String DIAG_PATH = "path";
    private static final String DIAG_DEPENDENCIES = "dependencies";
    private static final String TARGET_HANDLER = "handler";
    private static final String TARGET_DEFAULT = "default";
    private static final String TARGET_STATS_USING = "using";
    private static final String TARGET_STATS_REFERENCING = "referencing";
    private static final String PREF_VALUE = "value";
    private static final String PREF_CATEGORY = "category";
    private static final String JOB_NAME = "job-name";
    private static final String JOB_APP_NAME = "app-name";
    private static final String JOB_CMD_NAME = "cmd-name";
    private static final String WS_EVENT = "event";
    private static final String WS_APP = "app";
    private static final String WS_TPL = "tpl";
    private static final String WS_INST = "inst";
    private static final String WS_MSG = "msg";

    public static Map<Class<?>, ? super JsonSerializer<?>> getSerializers() {
        return Collections.unmodifiableMap(SERIALIZERS);
    }

    private JSonBindingUtils() {
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule("RoboconfModule", new Version(1, 0, 0, null, null, null));
        for (Map.Entry<Class<?>, JsonSerializer<?>> entry : SERIALIZERS.entrySet()) {
            module.addSerializer(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, JsonSerializer<?>> entry : DESERIALIZERS.entrySet()) {
            module.addDeserializer(entry.getKey(), (JsonDeserializer)entry.getValue());
        }
        mapper.registerModule((Module)module);
        return mapper;
    }

    static {
        SERIALIZERS.put(Instance.class, new InstanceSerializer());
        DESERIALIZERS.put(Instance.class, new InstanceDeserializer());
        SERIALIZERS.put(ApplicationTemplate.class, new ApplicationTemplateSerializer());
        DESERIALIZERS.put(ApplicationTemplate.class, new ApplicationTemplateDeserializer());
        SERIALIZERS.put(Application.class, new ApplicationSerializer());
        DESERIALIZERS.put(Application.class, new ApplicationDeserializer());
        SERIALIZERS.put(Component.class, new ComponentSerializer());
        DESERIALIZERS.put(Component.class, new ComponentDeserializer());
        SERIALIZERS.put(Diagnostic.class, new DiagnosticSerializer());
        DESERIALIZERS.put(Diagnostic.class, new DiagnosticDeserializer());
        SERIALIZERS.put(Diagnostic.DependencyInformation.class, new DependencyInformationSerializer());
        DESERIALIZERS.put(Diagnostic.DependencyInformation.class, new DependencyInformationDeserializer());
        SERIALIZERS.put(TargetWrapperDescriptor.class, new TargetWDSerializer());
        DESERIALIZERS.put(TargetWrapperDescriptor.class, new TargetWDDeserializer());
        SERIALIZERS.put(StringWrapper.class, new StringWrapperSerializer());
        DESERIALIZERS.put(StringWrapper.class, new StringWrapperDeserializer());
        SERIALIZERS.put(MapWrapper.class, new MapWrapperSerializer());
        DESERIALIZERS.put(MapWrapper.class, new MapWrapperDeserializer());
        SERIALIZERS.put(ScheduledJob.class, new ScheduledJobSerializer());
        DESERIALIZERS.put(ScheduledJob.class, new ScheduledJobDeserializer());
        SERIALIZERS.put(Preference.class, new PreferenceSerializer());
        DESERIALIZERS.put(Preference.class, new PreferenceDeserializer());
        SERIALIZERS.put(MappedCollectionWrapper.class, new MappedCollectionWrapperSerializer());
        SERIALIZERS.put(TargetUsageItem.class, new TargetUsageItemSerializer());
        SERIALIZERS.put(TargetAssociation.class, new TargetAssociationSerializer());
        SERIALIZERS.put(ApplicationBindings.class, new ApplicationBindingsSerializer());
        SERIALIZERS.put(WebSocketMessage.class, new WebSocketMessageSerializer());
        SERIALIZERS.put(CommandHistoryItem.class, new CommandHistoryItemSerializer());
    }

    public static class ComponentDeserializer
    extends JsonDeserializer<Component> {
        public Component deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            Component component = new Component();
            JsonNode n = node.get(JSonBindingUtils.NAME);
            if (n != null) {
                component.setName(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.COMP_INSTALLER)) != null) {
                component.setInstallerName(n.textValue());
            }
            return component;
        }
    }

    public static class ComponentSerializer
    extends JsonSerializer<Component> {
        public void serialize(Component component, JsonGenerator generator, SerializerProvider provider) throws IOException {
            String installerName;
            generator.writeStartObject();
            if (component.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, component.getName());
            }
            if ((installerName = ComponentHelpers.findComponentInstaller((Component)component)) != null) {
                generator.writeStringField(JSonBindingUtils.COMP_INSTALLER, installerName);
            }
            generator.writeEndObject();
        }
    }

    public static class InstanceDeserializer
    extends JsonDeserializer<Instance> {
        public Instance deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            Instance instance = new Instance();
            JsonNode n = node.get(JSonBindingUtils.NAME);
            if (n != null) {
                instance.setName(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.INST_STATUS)) != null) {
                instance.setStatus(Instance.InstanceStatus.whichStatus((String)n.textValue()));
            }
            if ((n = node.get(JSonBindingUtils.INST_CHANNELS)) != null) {
                for (JsonNode arrayNodeItem : n) {
                    instance.channels.add(arrayNodeItem.textValue());
                }
            }
            ObjectMapper mapper = JSonBindingUtils.createObjectMapper();
            n = node.get(JSonBindingUtils.INST_EXPORTS);
            if (n != null) {
                Map exports = (Map)mapper.readValue(n.toString(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
                instance.overriddenExports.putAll(exports);
            }
            if ((n = node.get(JSonBindingUtils.INST_COMPONENT)) != null) {
                Component instanceComponent = (Component)mapper.readValue(n.toString(), Component.class);
                instance.setComponent(instanceComponent);
            }
            if ((n = node.get("path")) != null) {
                instance.data.put(JSonBindingUtils.AT_INSTANCE_PATH, n.textValue());
            }
            return instance;
        }
    }

    public static class InstanceSerializer
    extends JsonSerializer<Instance> {
        public void serialize(Instance instance, JsonGenerator generator, SerializerProvider provider) throws IOException {
            Map exports;
            generator.writeStartObject();
            if (instance.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, instance.getName());
                generator.writeStringField("path", InstanceHelpers.computeInstancePath((Instance)instance));
            }
            if (instance.getStatus() != null) {
                generator.writeStringField(JSonBindingUtils.INST_STATUS, String.valueOf(instance.getStatus()));
            }
            if (instance.getComponent() != null) {
                generator.writeObjectField(JSonBindingUtils.INST_COMPONENT, (Object)instance.getComponent());
            }
            if (!instance.channels.isEmpty()) {
                generator.writeArrayFieldStart(JSonBindingUtils.INST_CHANNELS);
                for (String channel : instance.channels) {
                    generator.writeString(channel);
                }
                generator.writeEndArray();
            }
            if (!(exports = InstanceHelpers.findAllExportedVariables((Instance)instance)).isEmpty()) {
                generator.writeFieldName(JSonBindingUtils.INST_EXPORTS);
                generator.writeStartObject();
                for (Map.Entry entry : exports.entrySet()) {
                    generator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                generator.writeEndObject();
            }
            if (!instance.data.isEmpty()) {
                generator.writeFieldName(JSonBindingUtils.INST_DATA);
                generator.writeStartObject();
                for (Map.Entry entry : instance.data.entrySet()) {
                    generator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
    }

    public static class ApplicationDeserializer
    extends JsonDeserializer<Application> {
        public Application deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Application application;
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            JsonNode n = node.get(JSonBindingUtils.APP_INST_TPL_NAME);
            if (n != null) {
                ApplicationTemplate appTemplate = new ApplicationTemplate();
                appTemplate.setName(n.textValue());
                n = node.get(JSonBindingUtils.APP_INST_TPL_VERSION);
                if (n != null) {
                    appTemplate.setVersion(n.textValue());
                }
                if ((n = node.get(JSonBindingUtils.APP_INST_TPL_EEP)) != null) {
                    appTemplate.setExternalExportsPrefix(n.textValue());
                }
                application = new Application(appTemplate);
            } else {
                application = new Application(null);
            }
            n = node.get(JSonBindingUtils.DISPLAY_NAME);
            if (n != null) {
                application.setName(n.textValue());
            } else {
                n = node.get(JSonBindingUtils.NAME);
                if (n != null) {
                    application.setName(n.textValue());
                }
            }
            n = node.get(JSonBindingUtils.DESC);
            if (n != null) {
                application.setDescription(n.textValue());
            }
            return application;
        }
    }

    public static class ApplicationSerializer
    extends JsonSerializer<Application> {
        public void serialize(Application app, JsonGenerator generator, SerializerProvider provider) throws IOException {
            Set prefixesForExternalImports;
            String iconLocation;
            generator.writeStartObject();
            if (app.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, app.getName());
            }
            if (app.getDisplayName() != null) {
                generator.writeStringField(JSonBindingUtils.DISPLAY_NAME, app.getDisplayName());
            }
            if (app.getDescription() != null) {
                generator.writeStringField(JSonBindingUtils.DESC, app.getDescription());
            }
            if (app.getTemplate() != null) {
                Map externalExports;
                generator.writeStringField(JSonBindingUtils.APP_INST_TPL_NAME, app.getTemplate().getName());
                if (app.getTemplate().getVersion() != null) {
                    generator.writeStringField(JSonBindingUtils.APP_INST_TPL_VERSION, app.getTemplate().getVersion());
                }
                if (app.getTemplate().getExternalExportsPrefix() != null) {
                    generator.writeStringField(JSonBindingUtils.APP_INST_TPL_EEP, app.getTemplate().getExternalExportsPrefix());
                }
                if (!(externalExports = app.getTemplate().externalExports).isEmpty()) {
                    generator.writeObjectField(JSonBindingUtils.EXT_VARS, (Object)new MapWrapper(externalExports));
                }
            }
            if (!Utils.isEmptyOrWhitespaces((String)(iconLocation = IconUtils.findIconUrl((AbstractApplication)app)))) {
                generator.writeStringField(JSonBindingUtils.APP_ICON, iconLocation);
            }
            if (!(prefixesForExternalImports = VariableHelpers.findPrefixesForExternalImports((AbstractApplication)app)).isEmpty()) {
                generator.writeArrayFieldStart(JSonBindingUtils.EXT_DEP);
                for (String prefix : prefixesForExternalImports) {
                    generator.writeString(prefix);
                }
                generator.writeEndArray();
            }
            String info = null;
            for (Instance rootInstance : app.getRootInstances()) {
                if (rootInstance.getStatus() == Instance.InstanceStatus.PROBLEM) {
                    info = "warn";
                    break;
                }
                if (rootInstance.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) continue;
                info = "ok";
                break;
            }
            if (info != null) {
                generator.writeObjectField(JSonBindingUtils.APP_INFO, info);
            }
            generator.writeEndObject();
        }
    }

    public static class WebSocketMessageSerializer
    extends JsonSerializer<WebSocketMessage> {
        public void serialize(WebSocketMessage wsm, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (wsm.getEventType() != null) {
                generator.writeStringField(JSonBindingUtils.WS_EVENT, wsm.getEventType().toString());
            }
            if (wsm.getApplication() != null) {
                generator.writeObjectField(JSonBindingUtils.WS_APP, (Object)wsm.getApplication());
            }
            if (wsm.getApplicationTemplate() != null) {
                generator.writeObjectField(JSonBindingUtils.WS_TPL, (Object)wsm.getApplicationTemplate());
            }
            if (wsm.getInstance() != null) {
                generator.writeObjectField(JSonBindingUtils.WS_INST, (Object)wsm.getInstance());
            }
            if (wsm.getMessage() != null) {
                generator.writeObjectField(JSonBindingUtils.WS_MSG, (Object)wsm.getMessage());
            }
            generator.writeEndObject();
        }
    }

    public static class ApplicationBindingsSerializer
    extends JsonSerializer<ApplicationBindings> {
        public void serialize(ApplicationBindings bindings, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            for (Map.Entry<String, List<ApplicationBindings.ApplicationBindingItem>> entry : bindings.prefixToItems.entrySet()) {
                generator.writeArrayFieldStart(entry.getKey());
                for (ApplicationBindings.ApplicationBindingItem item : entry.getValue()) {
                    generator.writeStartObject();
                    generator.writeStringField(JSonBindingUtils.NAME, item.getApplicationName());
                    generator.writeBooleanField(JSonBindingUtils.BOUND, item.isBound());
                    generator.writeEndObject();
                }
                generator.writeEndArray();
            }
            generator.writeEndObject();
        }
    }

    public static class DependencyInformationDeserializer
    extends JsonDeserializer<Diagnostic.DependencyInformation> {
        public Diagnostic.DependencyInformation deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            Diagnostic.DependencyInformation info = new Diagnostic.DependencyInformation();
            JsonNode n = node.get(JSonBindingUtils.NAME);
            if (n != null) {
                info.setDependencyName(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.DEP_OPTIONAL)) != null) {
                info.setOptional(Boolean.valueOf(n.textValue()));
            }
            if ((n = node.get(JSonBindingUtils.DEP_RESOLVED)) != null) {
                info.setResolved(Boolean.valueOf(n.textValue()));
            }
            return info;
        }
    }

    public static class DependencyInformationSerializer
    extends JsonSerializer<Diagnostic.DependencyInformation> {
        public void serialize(Diagnostic.DependencyInformation info, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (info.getDependencyName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, info.getDependencyName());
            }
            generator.writeStringField(JSonBindingUtils.DEP_OPTIONAL, String.valueOf(info.isOptional()));
            generator.writeStringField(JSonBindingUtils.DEP_RESOLVED, String.valueOf(info.isResolved()));
            generator.writeEndObject();
        }
    }

    public static class DiagnosticDeserializer
    extends JsonDeserializer<Diagnostic> {
        public Diagnostic deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            Diagnostic diag = new Diagnostic();
            JsonNode n = node.get("path");
            if (n != null) {
                diag.setInstancePath(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.DIAG_DEPENDENCIES)) != null) {
                for (JsonNode arrayNodeItem : n) {
                    ObjectMapper mapper = JSonBindingUtils.createObjectMapper();
                    Diagnostic.DependencyInformation info = (Diagnostic.DependencyInformation)mapper.readValue(arrayNodeItem.toString(), Diagnostic.DependencyInformation.class);
                    diag.getDependenciesInformation().add(info);
                }
            }
            return diag;
        }
    }

    public static class DiagnosticSerializer
    extends JsonSerializer<Diagnostic> {
        public void serialize(Diagnostic diag, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (diag.getInstancePath() != null) {
                generator.writeStringField("path", diag.getInstancePath());
            }
            generator.writeArrayFieldStart(JSonBindingUtils.DIAG_DEPENDENCIES);
            for (Diagnostic.DependencyInformation info : diag.getDependenciesInformation()) {
                generator.writeObject((Object)info);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }

    public static class ApplicationTemplateDeserializer
    extends JsonDeserializer<ApplicationTemplate> {
        public ApplicationTemplate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            ApplicationTemplate application = new ApplicationTemplate();
            JsonNode n = node.get(JSonBindingUtils.DISPLAY_NAME);
            if (n != null) {
                application.setName(n.textValue());
            } else {
                n = node.get(JSonBindingUtils.NAME);
                if (n != null) {
                    application.setName(n.textValue());
                }
            }
            n = node.get(JSonBindingUtils.DESC);
            if (n != null) {
                application.setDescription(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.VERSION)) != null) {
                application.setVersion(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.EEP)) != null) {
                application.setExternalExportsPrefix(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.APP_TPL_TAGS)) != null) {
                for (JsonNode arrayNodeItem : n) {
                    application.addTag(arrayNodeItem.textValue());
                }
            }
            return application;
        }
    }

    public static class MappedCollectionWrapperSerializer
    extends JsonSerializer<MappedCollectionWrapper> {
        public void serialize(MappedCollectionWrapper m, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            for (Map.Entry<String, ? extends Collection<String>> entry : m.getMap().entrySet()) {
                generator.writeArrayFieldStart(entry.getKey() == null ? "" : entry.getKey());
                if (entry.getValue() != null) {
                    for (String item : entry.getValue()) {
                        generator.writeString(item);
                    }
                }
                generator.writeEndArray();
            }
            generator.writeEndObject();
        }
    }

    public static class ApplicationTemplateSerializer
    extends JsonSerializer<ApplicationTemplate> {
        public void serialize(ApplicationTemplate app, JsonGenerator generator, SerializerProvider provider) throws IOException {
            Set prefixesForExternalImports;
            String iconLocation;
            generator.writeStartObject();
            if (app.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, app.getName());
            }
            if (app.getDisplayName() != null) {
                generator.writeStringField(JSonBindingUtils.DISPLAY_NAME, app.getDisplayName());
            }
            if (app.getDescription() != null) {
                generator.writeStringField(JSonBindingUtils.DESC, app.getDescription());
            }
            if (app.getVersion() != null) {
                generator.writeStringField(JSonBindingUtils.VERSION, app.getVersion());
            }
            if (app.getExternalExportsPrefix() != null) {
                generator.writeStringField(JSonBindingUtils.EEP, app.getExternalExportsPrefix());
            }
            if (!app.externalExports.isEmpty()) {
                generator.writeObjectField(JSonBindingUtils.EXT_VARS, (Object)new MapWrapper(app.externalExports));
            }
            if (!Utils.isEmptyOrWhitespaces((String)(iconLocation = IconUtils.findIconUrl((AbstractApplication)app)))) {
                generator.writeStringField(JSonBindingUtils.APP_ICON, iconLocation);
            }
            if (!(prefixesForExternalImports = VariableHelpers.findPrefixesForExternalImports((AbstractApplication)app)).isEmpty()) {
                generator.writeArrayFieldStart(JSonBindingUtils.EXT_DEP);
                for (String prefix : prefixesForExternalImports) {
                    generator.writeString(prefix);
                }
                generator.writeEndArray();
            }
            generator.writeArrayFieldStart(JSonBindingUtils.APP_TPL_APPS);
            for (Application associatedApp : app.getAssociatedApplications()) {
                if (associatedApp == null || associatedApp.getName() == null) continue;
                generator.writeString(associatedApp.getName());
            }
            generator.writeEndArray();
            Set tags = app.getTags();
            if (!tags.isEmpty()) {
                generator.writeArrayFieldStart(JSonBindingUtils.APP_TPL_TAGS);
                for (String s : tags) {
                    generator.writeString(s);
                }
                generator.writeEndArray();
            }
            generator.writeEndObject();
        }
    }

    public static class MapWrapperSerializer
    extends JsonSerializer<MapWrapper> {
        public void serialize(MapWrapper m, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : m.getMap().entrySet()) {
                generator.writeStringField(entry.getKey() == null ? "" : entry.getKey(), entry.getValue() == null ? "" : entry.getValue());
            }
            generator.writeEndObject();
        }
    }

    public static class MapWrapperDeserializer
    extends JsonDeserializer<MapWrapper> {
        public MapWrapper deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                map.put((String)entry.getKey(), ((JsonNode)entry.getValue()).textValue());
            }
            return new MapWrapper(map);
        }
    }

    public static class StringWrapperSerializer
    extends JsonSerializer<StringWrapper> {
        public void serialize(StringWrapper s, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (s.toString() != null) {
                generator.writeStringField(JSonBindingUtils.S, s.toString());
            }
            generator.writeEndObject();
        }
    }

    public static class StringWrapperDeserializer
    extends JsonDeserializer<StringWrapper> {
        public StringWrapper deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            String s = null;
            JsonNode n = node.get(JSonBindingUtils.S);
            if (n != null) {
                s = n.textValue();
            }
            return new StringWrapper(s);
        }
    }

    public static class TargetWDDeserializer
    extends JsonDeserializer<TargetWrapperDescriptor> {
        public TargetWrapperDescriptor deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            TargetWrapperDescriptor twd = new TargetWrapperDescriptor();
            JsonNode n = node.get(JSonBindingUtils.DESC);
            if (n != null) {
                twd.setDescription(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.TARGET_HANDLER)) != null) {
                twd.setHandler(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.ID)) != null) {
                twd.setId(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.NAME)) != null) {
                twd.setName(n.textValue());
            }
            return twd;
        }
    }

    public static class TargetWDSerializer
    extends JsonSerializer<TargetWrapperDescriptor> {
        public void serialize(TargetWrapperDescriptor twd, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (twd.getId() != null) {
                generator.writeStringField(JSonBindingUtils.ID, twd.getId());
            }
            if (twd.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, twd.getName());
            }
            if (twd.getHandler() != null) {
                generator.writeStringField(JSonBindingUtils.TARGET_HANDLER, twd.getHandler());
            }
            if (twd.getDescription() != null) {
                generator.writeStringField(JSonBindingUtils.DESC, twd.getDescription());
            }
            if (twd.isDefault()) {
                generator.writeStringField(JSonBindingUtils.TARGET_DEFAULT, "true");
            }
            generator.writeEndObject();
        }
    }

    public static class PreferenceDeserializer
    extends JsonDeserializer<Preference> {
        public Preference deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            String name = null;
            String value = null;
            String cat = null;
            JsonNode n = node.get(JSonBindingUtils.NAME);
            if (n != null) {
                name = n.textValue();
            }
            if ((n = node.get(JSonBindingUtils.PREF_VALUE)) != null) {
                value = n.textValue();
            }
            if ((n = node.get(JSonBindingUtils.PREF_CATEGORY)) != null) {
                cat = n.textValue();
            }
            return new Preference(name, value, Preference.PreferenceKeyCategory.which((String)cat));
        }
    }

    public static class PreferenceSerializer
    extends JsonSerializer<Preference> {
        public void serialize(Preference item, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (item.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, item.getName());
            }
            if (item.getValue() != null) {
                generator.writeObjectField(JSonBindingUtils.PREF_VALUE, (Object)item.getValue());
            }
            if (item.getCategory() != null) {
                generator.writeObjectField(JSonBindingUtils.PREF_CATEGORY, (Object)item.getCategory().toString().toLowerCase());
            }
            generator.writeEndObject();
        }
    }

    public static class CommandHistoryItemSerializer
    extends JsonSerializer<CommandHistoryItem> {
        public void serialize(CommandHistoryItem item, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (item.getApplicationName() != null) {
                generator.writeStringField(JSonBindingUtils.WS_APP, item.getApplicationName());
            }
            if (item.getCommandName() != null) {
                generator.writeStringField("cmd", item.getCommandName());
            }
            if (item.getOriginDetails() != null) {
                generator.writeStringField("details", item.getOriginDetails());
            }
            long startInMilliSec = item.getStart();
            long durationInMilliSec = TimeUnit.MILLISECONDS.convert(item.getDuration(), TimeUnit.NANOSECONDS);
            generator.writeNumberField("start", startInMilliSec);
            generator.writeNumberField("duration", durationInMilliSec);
            generator.writeNumberField("result", item.getExecutionResult());
            generator.writeNumberField("origin", item.getOrigin());
            generator.writeEndObject();
        }
    }

    public static class TargetAssociationSerializer
    extends JsonSerializer<TargetAssociation> {
        public void serialize(TargetAssociation item, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (item.getInstancePathOrComponentName() != null) {
                generator.writeStringField("path", item.getInstancePathOrComponentName());
            }
            if (item.getInstanceComponent() != null) {
                generator.writeStringField(JSonBindingUtils.INST_COMPONENT, item.getInstanceComponent());
            }
            if (item.getTargetDescriptor() != null) {
                generator.writeObjectField(JSonBindingUtils.DESC, (Object)item.getTargetDescriptor());
            }
            generator.writeEndObject();
        }
    }

    public static class ScheduledJobDeserializer
    extends JsonDeserializer<ScheduledJob> {
        public ScheduledJob deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            ScheduledJob job = new ScheduledJob();
            JsonNode n = node.get(JSonBindingUtils.ID);
            if (n != null) {
                job.setJobId(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.JOB_NAME)) != null) {
                job.setJobName(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.JOB_APP_NAME)) != null) {
                job.setAppName(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.JOB_CMD_NAME)) != null) {
                job.setCmdName(n.textValue());
            }
            if ((n = node.get(JSonBindingUtils.CRON)) != null) {
                job.setCron(n.textValue());
            }
            return job;
        }
    }

    public static class ScheduledJobSerializer
    extends JsonSerializer<ScheduledJob> {
        public void serialize(ScheduledJob job, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (job.getJobId() != null) {
                generator.writeStringField(JSonBindingUtils.ID, job.getJobId());
            }
            if (job.getAppName() != null) {
                generator.writeStringField(JSonBindingUtils.JOB_APP_NAME, job.getAppName());
            }
            if (job.getCmdName() != null) {
                generator.writeStringField(JSonBindingUtils.JOB_CMD_NAME, job.getCmdName());
            }
            if (job.getJobName() != null) {
                generator.writeStringField(JSonBindingUtils.JOB_NAME, job.getJobName());
            }
            if (job.getCron() != null) {
                generator.writeStringField(JSonBindingUtils.CRON, job.getCron());
            }
            generator.writeEndObject();
        }
    }

    public static class TargetUsageItemSerializer
    extends JsonSerializer<TargetUsageItem> {
        public void serialize(TargetUsageItem item, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            if (item.getName() != null) {
                generator.writeStringField(JSonBindingUtils.NAME, item.getName());
            }
            if (item.getVersion() != null) {
                generator.writeStringField(JSonBindingUtils.VERSION, item.getVersion());
            }
            if (item.isUsing()) {
                generator.writeStringField(JSonBindingUtils.TARGET_STATS_USING, "true");
            }
            if (item.isReferencing()) {
                generator.writeStringField(JSonBindingUtils.TARGET_STATS_REFERENCING, "true");
            }
            generator.writeEndObject();
        }
    }
}

