/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.commons.security;

import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class AuthenticationManager {
    private final ConcurrentHashMap<String, Long> tokenToLoginTime = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tokenToUsername = new ConcurrentHashMap();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String realm;
    private IAuthService authService;

    public AuthenticationManager(String realm) {
        this.realm = realm;
        this.authService = new KarafAuthService();
        this.authService.setRealm(this.realm);
    }

    public void setAuthService(IAuthService authService) {
        this.authService = authService;
        authService.setRealm(this.realm);
    }

    public String login(String user, String pwd) {
        String token = null;
        try {
            this.authService.authenticate(user, pwd);
            token = UUID.randomUUID().toString();
            Long now = new Date().getTime();
            this.tokenToLoginTime.put(token, now);
            this.tokenToUsername.put(token, user);
        }
        catch (LoginException e) {
            this.logger.severe("Invalid login attempt by user " + user);
        }
        return token;
    }

    public boolean isSessionValid(String token, long validityPeriod) {
        boolean valid = false;
        Long loginTime = null;
        if (token != null) {
            loginTime = this.tokenToLoginTime.get(token);
        }
        if (validityPeriod < 0L) {
            valid = loginTime != null;
        } else if (loginTime != null) {
            long now = new Date().getTime();
            boolean bl = valid = now - loginTime <= validityPeriod * 1000L;
            if (!valid) {
                this.logout(token);
            }
        }
        return valid;
    }

    public void logout(String token) {
        if (token != null) {
            this.tokenToLoginTime.remove(token);
            this.tokenToUsername.remove(token);
        }
    }

    public String findUsername(String token) {
        return token == null ? null : this.tokenToUsername.get(token);
    }

    static final class RoboconfCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public RoboconfCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    public static class KarafAuthService
    implements IAuthService {
        private String realm;

        @Override
        public void authenticate(String user, String pwd) throws LoginException {
            LoginContext loginCtx = new LoginContext(this.realm, new RoboconfCallbackHandler(user, pwd));
            loginCtx.login();
        }

        @Override
        public void setRealm(String realm) {
            this.realm = realm;
        }
    }

    public static interface IAuthService {
        public void authenticate(String var1, String var2) throws LoginException;

        public void setRealm(String var1);
    }
}

