/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.RoboconfError;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.utils.ConfigurationUtils;
import net.roboconf.dm.management.api.IApplicationMngr;
import net.roboconf.dm.management.api.IApplicationTemplateMngr;
import net.roboconf.dm.management.api.IConfigurationMngr;
import net.roboconf.dm.management.api.INotificationMngr;
import net.roboconf.dm.management.api.ITargetsMngr;
import net.roboconf.dm.management.exceptions.AlreadyExistingException;
import net.roboconf.dm.management.exceptions.InvalidApplicationException;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;

public class ApplicationTemplateMngrImpl
implements IApplicationTemplateMngr {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final INotificationMngr notificationMngr;
    private final IConfigurationMngr configurationMngr;
    private final ITargetsMngr targetsMngr;
    private final IApplicationMngr applicationMngr;
    final Map<ApplicationTemplate, Boolean> templates = new ConcurrentHashMap<ApplicationTemplate, Boolean>();
    private static final Object INSTALL_LOCK = new Object();

    public ApplicationTemplateMngrImpl(INotificationMngr notificationMngr, ITargetsMngr targetsMngr, IApplicationMngr applicationMngr, IConfigurationMngr configurationMngr) {
        this.notificationMngr = notificationMngr;
        this.targetsMngr = targetsMngr;
        this.applicationMngr = applicationMngr;
        this.configurationMngr = configurationMngr;
    }

    @Override
    public Set<ApplicationTemplate> getApplicationTemplates() {
        return this.templates.keySet();
    }

    @Override
    public ApplicationTemplate findTemplate(String name, String version) {
        ApplicationTemplate result = null;
        for (ApplicationTemplate tpl : this.templates.keySet()) {
            if (!Objects.equals(tpl.getName(), name) || !Objects.equals(tpl.getVersion(), version)) continue;
            result = tpl;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationTemplate loadApplicationTemplate(File applicationFilesDirectory) throws AlreadyExistingException, InvalidApplicationException, IOException, UnauthorizedActionException {
        Object object = INSTALL_LOCK;
        synchronized (object) {
            this.logger.info("Loading an application template from " + applicationFilesDirectory + "...");
            RuntimeModelIo.ApplicationLoadResult lr = RuntimeModelIo.loadApplication((File)applicationFilesDirectory);
            if (RoboconfErrorHelpers.containsCriticalErrors((Collection)lr.getLoadErrors())) {
                throw new InvalidApplicationException(lr.getLoadErrors());
            }
            Collection warnings = RoboconfErrorHelpers.findWarnings((Collection)lr.getLoadErrors());
            for (String warningMsg : RoboconfErrorHelpers.formatErrors((Collection)warnings, null, (boolean)true).values()) {
                this.logger.warning(warningMsg);
            }
            ApplicationTemplate tpl = lr.getApplicationTemplate();
            if (this.templates.containsKey(tpl)) {
                throw new AlreadyExistingException(tpl.getName());
            }
            HashSet<String> externExportPrefixes = new HashSet<String>();
            for (ApplicationTemplate otherTpl : this.templates.keySet()) {
                if (otherTpl.getExternalExportsPrefix() == null) continue;
                externExportPrefixes.add(otherTpl.getExternalExportsPrefix());
            }
            if (externExportPrefixes.contains(tpl.getExternalExportsPrefix())) {
                throw new IOException("The external exports prefix is already used by another template.");
            }
            Set<String> newTargetIds = this.registerTargets(tpl);
            File targetDirectory = ConfigurationUtils.findTemplateDirectory(tpl, this.configurationMngr.getWorkingDirectory());
            try {
                if (!applicationFilesDirectory.equals(targetDirectory)) {
                    if (Utils.isAncestorFile((File)targetDirectory, (File)applicationFilesDirectory)) {
                        throw new IOException("Cannot move " + applicationFilesDirectory + " in Roboconf's work directory. Already a child directory.");
                    }
                    Utils.copyDirectory((File)applicationFilesDirectory, (File)targetDirectory);
                }
            }
            catch (IOException e) {
                this.unregisterTargets(newTargetIds);
                throw e;
            }
            tpl.setDirectory(targetDirectory);
            for (File targetDir : ResourceUtils.findScopedInstancesDirectories((AbstractApplication)tpl).values()) {
                Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{targetDir});
            }
            this.templates.put(tpl, Boolean.TRUE);
            this.logger.info("Application template " + tpl.getName() + " was successfully loaded.");
            this.notificationMngr.applicationTemplate(tpl, EventType.CREATED);
            return tpl;
        }
    }

    @Override
    public void deleteApplicationTemplate(String tplName, String tplVersion) throws UnauthorizedActionException, InvalidApplicationException, IOException {
        ApplicationTemplate tpl = this.findTemplate(tplName, tplVersion);
        if (tpl == null) {
            throw new InvalidApplicationException(new RoboconfError(ErrorCode.PROJ_APPLICATION_TEMPLATE_NOT_FOUND));
        }
        if (this.applicationMngr.isTemplateUsed(tpl)) {
            throw new UnauthorizedActionException(tplName + " (" + tplVersion + ") is still used by applications. It cannot be deleted.");
        }
        this.logger.info("Deleting the application template called " + tpl.getName() + "...");
        this.templates.remove(tpl);
        this.notificationMngr.applicationTemplate(tpl, EventType.DELETED);
        this.targetsMngr.applicationWasDeleted((AbstractApplication)tpl);
        File targetDirectory = ConfigurationUtils.findTemplateDirectory(tpl, this.configurationMngr.getWorkingDirectory());
        Utils.deleteFilesRecursively((File[])new File[]{targetDirectory});
        this.logger.info("Application template " + tpl.getName() + " was successfully deleted.");
    }

    @Override
    public void restoreTemplates() {
        File configurationDirectory = this.configurationMngr.getWorkingDirectory();
        this.logger.info("Restoring application templates from " + configurationDirectory + "...");
        this.templates.clear();
        File templatesDirectory = new File(configurationDirectory, "application-templates");
        for (File dir : Utils.listDirectories((File)templatesDirectory)) {
            try {
                this.loadApplicationTemplate(dir);
            }
            catch (IOException | AlreadyExistingException | InvalidApplicationException | UnauthorizedActionException e) {
                this.logger.warning("Cannot restore application template in " + dir + " (" + e.getClass().getSimpleName() + ").");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
        this.logger.info("Application templates restoration from " + configurationDirectory + " has just completed.");
    }

    private Set<String> registerTargets(ApplicationTemplate tpl) throws IOException, UnauthorizedActionException {
        IOException conflictException = null;
        HashSet<String> newTargetIds = new HashSet<String>();
        HashMap componentToTargetIds = new HashMap();
        block2: for (Map.Entry entry : ResourceUtils.findScopedInstancesDirectories((AbstractApplication)tpl).entrySet()) {
            String defaultTargetId = null;
            HashSet<String> targetIds = new HashSet<String>();
            componentToTargetIds.put(entry.getKey(), targetIds);
            for (File f : Utils.listDirectFiles((File)((File)entry.getValue()), (String)".properties")) {
                String targetId;
                this.logger.fine("Registering target " + f.getName() + " from component " + entry.getKey() + " in application template " + tpl);
                try {
                    targetId = this.targetsMngr.createTarget(f, tpl);
                }
                catch (IOException e) {
                    conflictException = e;
                    break block2;
                }
                this.targetsMngr.addHint(targetId, (AbstractApplication)tpl);
                targetIds.add(targetId);
                newTargetIds.add(targetId);
                if (!"target.properties".equalsIgnoreCase(f.getName())) continue;
                defaultTargetId = targetId;
            }
            if (defaultTargetId == null) continue;
            targetIds.clear();
            targetIds.add(defaultTargetId);
        }
        if (conflictException != null) {
            this.logger.fine("A conflict was found while registering ");
            this.unregisterTargets(newTargetIds);
            throw conflictException;
        }
        for (Map.Entry entry : componentToTargetIds.entrySet()) {
            String key = "@" + ((Component)entry.getKey()).getName();
            if (((Set)entry.getValue()).size() != 1) continue;
            this.targetsMngr.associateTargetWith((String)((Set)entry.getValue()).iterator().next(), (AbstractApplication)tpl, key);
        }
        return newTargetIds;
    }

    private void unregisterTargets(Set<String> newTargetIds) {
        for (String targetId : newTargetIds) {
            try {
                this.targetsMngr.deleteTarget(targetId);
            }
            catch (Exception e) {
                this.logger.severe("A target ID that has just been registered could not be created. That's weird.");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }
}

