/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.IOException;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IDebugMngr;
import net.roboconf.dm.management.api.IMessagingMngr;
import net.roboconf.dm.management.api.INotificationMngr;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_dm_to_dm.MsgEcho;

public class DebugMngrImpl
implements IDebugMngr {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final IMessagingMngr messagingMngr;
    private final INotificationMngr notificationMngr;

    public DebugMngrImpl(IMessagingMngr messagingMngr, INotificationMngr notificationMngr) {
        this.messagingMngr = messagingMngr;
        this.notificationMngr = notificationMngr;
    }

    @Override
    public boolean pingMessageQueue(String message) {
        boolean sent = false;
        MsgEcho sentMessage = new MsgEcho(message);
        try {
            this.messagingMngr.sendMessageToTheDm((Message)sentMessage);
            sent = true;
            this.logger.fine("Sent Echo message on debug queue. Message=" + message + ", UUID=" + sentMessage.getUuid());
        }
        catch (IOException e) {
            this.logger.fine("No Echo message was sent on debug queue. An error occurred with the messaging.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return sent;
    }

    @Override
    public int pingAgent(ManagedApplication app, Instance scopedInstance, String message) {
        int result;
        MsgEcho ping = new MsgEcho("PING:" + message);
        try {
            if (scopedInstance.getStatus() != Instance.InstanceStatus.NOT_DEPLOYED) {
                this.messagingMngr.sendMessageDirectly(app, scopedInstance, (Message)ping);
                this.logger.fine("Sent PING request message=" + message + " to application=" + app + ", agent=" + scopedInstance);
                result = 0;
            } else {
                this.logger.fine("No PING request was sent to application=" + app + ", agent=" + scopedInstance + ". The agent was not started.");
                result = 1;
            }
        }
        catch (IOException e) {
            this.logger.fine("No PING request was sent to application=" + app + ", agent=" + scopedInstance + ". An error occurred with the messaging.");
            Utils.logException((Logger)this.logger, (Throwable)e);
            result = 2;
        }
        return result;
    }

    @Override
    public void notifyMsgEchoReceived(MsgEcho message) {
        this.notificationMngr.raw(message.getContent(), new Object[0]);
    }
}

