/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.api.IRandomMngr;
import net.roboconf.dm.internal.api.ITargetConfigurator;
import net.roboconf.dm.internal.utils.ConfigurationUtils;
import net.roboconf.dm.internal.utils.DmUtils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IAutonomicMngr;
import net.roboconf.dm.management.api.IInstancesMngr;
import net.roboconf.dm.management.api.IMessagingMngr;
import net.roboconf.dm.management.api.INotificationMngr;
import net.roboconf.dm.management.api.ITargetHandlerResolver;
import net.roboconf.dm.management.api.ITargetsMngr;
import net.roboconf.dm.management.exceptions.ImpossibleInsertionException;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdAddInstance;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdChangeInstanceState;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdRemoveInstance;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdResynchronize;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdSendInstances;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdSetScopedInstance;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdUpdateProbeConfiguration;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandler;
import net.roboconf.target.api.TargetHandlerParameters;

public class InstancesMngrImpl
implements IInstancesMngr {
    private static final Object LOCK = new Object();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final IMessagingMngr messagingMngr;
    private final INotificationMngr notificationMngr;
    private final ITargetsMngr targetsMngr;
    private final IRandomMngr randomMngr;
    private final ITargetConfigurator targetConfigurator;
    private IAutonomicMngr autonomicMngr;
    private ITargetHandlerResolver targetHandlerResolver;
    private String dmDomain;

    public InstancesMngrImpl(IMessagingMngr messagingMngr, INotificationMngr notificationMngr, ITargetsMngr targetsMngr, IRandomMngr randomMngr, ITargetConfigurator targetConfigurator) {
        this.targetsMngr = targetsMngr;
        this.messagingMngr = messagingMngr;
        this.notificationMngr = notificationMngr;
        this.randomMngr = randomMngr;
        this.targetConfigurator = targetConfigurator;
    }

    public void setTargetHandlerResolver(ITargetHandlerResolver targetHandlerResolver) {
        this.targetHandlerResolver = targetHandlerResolver;
    }

    public void setRuleBasedHandler(IAutonomicMngr autonomicMngr) {
        this.autonomicMngr = autonomicMngr;
    }

    public void setDmDomain(String dmDomain) {
        this.dmDomain = dmDomain;
    }

    @Override
    public void addInstance(ManagedApplication ma, Instance parentInstance, Instance instance) throws ImpossibleInsertionException, IOException {
        this.messagingMngr.checkMessagingConfiguration();
        if (!InstanceHelpers.tryToInsertChildInstance((AbstractApplication)ma.getApplication(), (Instance)parentInstance, (Instance)instance)) {
            throw new ImpossibleInsertionException(instance.getName());
        }
        this.randomMngr.generateRandomValues(ma.getApplication(), instance);
        this.logger.fine("Instance " + InstanceHelpers.computeInstancePath((Instance)instance) + " was successfully added in " + ma.getName() + ".");
        Instance scopedInstance = InstanceHelpers.findScopedInstance((Instance)instance);
        ma.storeAwaitingMessage(instance, (Message)new MsgCmdAddInstance(scopedInstance));
        ConfigurationUtils.saveInstances(ma);
        this.notificationMngr.instance(instance, ma.getApplication(), EventType.CREATED);
    }

    @Override
    public void instanceWasUpdated(Instance instance, ManagedApplication ma) {
        this.notificationMngr.instance(instance, ma.getApplication(), EventType.CHANGED);
        ConfigurationUtils.saveInstances(ma);
    }

    @Override
    public void removeInstance(ManagedApplication ma, Instance instance) throws UnauthorizedActionException, IOException {
        this.removeInstance(ma, instance, true);
    }

    @Override
    public void removeInstance(ManagedApplication ma, Instance instance, boolean immediate) throws UnauthorizedActionException, IOException {
        this.messagingMngr.checkMessagingConfiguration();
        for (Instance i : InstanceHelpers.buildHierarchicalList((Instance)instance)) {
            if (i.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) continue;
            if (immediate) {
                throw new UnauthorizedActionException("Instances are still deployed or running. They cannot be removed in " + ma.getName() + ".");
            }
            instance.data.put("delete.when.not.deployed", "true");
            return;
        }
        MsgCmdRemoveInstance message = new MsgCmdRemoveInstance(instance);
        this.messagingMngr.sendMessageSafely(ma, instance, (Message)message);
        if (instance.getParent() == null) {
            ma.getApplication().getRootInstances().remove(instance);
            this.autonomicMngr.notifyVmWasDeletedByHand(instance);
        } else {
            instance.getParent().getChildren().remove(instance);
        }
        this.randomMngr.releaseRandomValues(ma.getApplication(), instance);
        this.releaseLockedTargets(ma.getApplication(), instance);
        this.logger.fine("Instance " + InstanceHelpers.computeInstancePath((Instance)instance) + " was successfully removed in " + ma.getName() + ".");
        ConfigurationUtils.saveInstances(ma);
        this.notificationMngr.instance(instance, ma.getApplication(), EventType.DELETED);
    }

    @Override
    public void restoreInstanceStates(ManagedApplication ma, TargetHandler targetHandler) {
        for (Instance scopedInstance : InstanceHelpers.findAllScopedInstances((AbstractApplication)ma.getApplication())) {
            try {
                String machineId = (String)scopedInstance.data.get("machine.id");
                if (machineId == null) {
                    DmUtils.markScopedInstanceAsNotDeployed(scopedInstance, ma, this.notificationMngr, this);
                    this.releaseLockedTargets(ma.getApplication(), scopedInstance);
                    continue;
                }
                String scopedInstancePath = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
                ITargetsMngr.TargetProperties targetProperties = this.targetsMngr.findTargetProperties((AbstractApplication)ma.getApplication(), scopedInstancePath);
                targetProperties.asMap().putAll(scopedInstance.data);
                TargetHandler readTargetHandler = null;
                try {
                    readTargetHandler = this.targetHandlerResolver.findTargetHandler(targetProperties.asMap());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (readTargetHandler == null || !Objects.equals(targetHandler.getTargetId(), readTargetHandler.getTargetId())) continue;
                TargetHandlerParameters parameters = this.parameters(ma, scopedInstance, targetProperties);
                if (!targetHandler.isMachineRunning(parameters, machineId)) {
                    DmUtils.markScopedInstanceAsNotDeployed(scopedInstance, ma, this.notificationMngr, this);
                    this.releaseLockedTargets(ma.getApplication(), scopedInstance);
                    continue;
                }
                this.messagingMngr.sendMessageDirectly(ma, scopedInstance, (Message)new MsgCmdSendInstances());
            }
            catch (Exception e) {
                this.logger.severe("Could not request states for agent " + scopedInstance.getName() + " (I/O exception).");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }

    @Override
    public void resynchronizeAgents(ManagedApplication ma) throws IOException {
        this.messagingMngr.checkMessagingConfiguration();
        this.logger.fine("Resynchronizing agents in " + ma.getName() + "...");
        for (Instance rootInstance : ma.getApplication().getRootInstances()) {
            if (rootInstance.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED) continue;
            this.messagingMngr.sendMessageDirectly(ma, rootInstance, (Message)new MsgCmdResynchronize());
        }
        this.logger.fine("Requests were sent to resynchronize agents in " + ma.getName() + ".");
    }

    @Override
    public void changeInstanceState(ManagedApplication ma, Instance instance, Instance.InstanceStatus newStatus) throws IOException, TargetException {
        this.messagingMngr.checkMessagingConfiguration();
        String instancePath = InstanceHelpers.computeInstancePath((Instance)instance);
        this.logger.fine("Trying to change the state of " + instancePath + " to " + newStatus + " in " + ma.getName() + "...");
        if (InstanceHelpers.isTarget((Instance)instance)) {
            List<Instance.InstanceStatus> es = Arrays.asList(Instance.InstanceStatus.DEPLOYED_STARTED, Instance.InstanceStatus.DEPLOYING, Instance.InstanceStatus.STARTING, Instance.InstanceStatus.PROBLEM);
            if (newStatus == Instance.InstanceStatus.NOT_DEPLOYED && es.contains(instance.getStatus())) {
                this.undeployTarget(ma, instance);
            } else if (instance.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED && newStatus == Instance.InstanceStatus.DEPLOYED_STARTED) {
                this.deployTarget(ma, instance);
            } else {
                this.logger.warning("Ignoring a request to update a scoped instance's state. New state was " + newStatus);
            }
        } else {
            Map instanceResources = null;
            if (newStatus == Instance.InstanceStatus.DEPLOYED_STARTED || newStatus == Instance.InstanceStatus.DEPLOYED_STOPPED) {
                instanceResources = ResourceUtils.storeInstanceResources((File)ma.getTemplateDirectory(), (Instance)instance);
            }
            MsgCmdChangeInstanceState message = new MsgCmdChangeInstanceState(instance, newStatus, instanceResources);
            this.messagingMngr.sendMessageSafely(ma, instance, (Message)message);
            this.logger.fine("A message was (or will be) sent to the agent to change the state of " + instancePath + " in " + ma.getName() + ".");
        }
    }

    @Override
    public void deployAndStartAll(ManagedApplication ma, Instance instance) throws IOException {
        this.messagingMngr.checkMessagingConfiguration();
        Collection<Object> initialInstances = instance != null ? Collections.singletonList(instance) : ma.getApplication().getRootInstances();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Instance instance2 : initialInstances) {
            for (Instance i : InstanceHelpers.buildHierarchicalList((Instance)instance2)) {
                try {
                    this.changeInstanceState(ma, i, Instance.InstanceStatus.DEPLOYED_STARTED);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        InstancesMngrImpl.processExceptions(this.logger, exceptions, "One or several errors occurred while deploying and starting instances.");
    }

    @Override
    public void stopAll(ManagedApplication ma, Instance instance) throws IOException {
        this.messagingMngr.checkMessagingConfiguration();
        Collection<Object> initialInstances = instance != null ? Collections.singletonList(instance) : ma.getApplication().getRootInstances();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Instance instance2 : initialInstances) {
            try {
                if (!InstanceHelpers.isTarget((Instance)instance2)) {
                    this.changeInstanceState(ma, instance2, Instance.InstanceStatus.DEPLOYED_STOPPED);
                    continue;
                }
                for (Instance i : instance2.getChildren()) {
                    this.changeInstanceState(ma, i, Instance.InstanceStatus.DEPLOYED_STOPPED);
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        InstancesMngrImpl.processExceptions(this.logger, exceptions, "One or several errors occurred while stopping instances.");
    }

    @Override
    public void undeployAll(ManagedApplication ma, Instance instance) throws IOException {
        this.messagingMngr.checkMessagingConfiguration();
        Collection<Object> initialInstances = instance != null ? Collections.singletonList(instance) : ma.getApplication().getRootInstances();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Instance instance2 : initialInstances) {
            try {
                this.changeInstanceState(ma, instance2, Instance.InstanceStatus.NOT_DEPLOYED);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        InstancesMngrImpl.processExceptions(this.logger, exceptions, "One or several errors occurred while undeploying instances.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployTarget(ManagedApplication ma, Instance scopedInstance) throws TargetException, IOException {
        String path = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
        this.logger.fine("Deploying scoped instance '" + path + "' in " + ma.getName() + "...");
        Object object = LOCK;
        synchronized (object) {
            if (scopedInstance.data.get("target.acquired") != null) {
                this.logger.finer("Scoped instance '" + path + "' is already under deployment. This redundant request is dropped.");
                return;
            }
            scopedInstance.data.put("target.acquired", "yes");
        }
        String machineId = (String)scopedInstance.data.get("machine.id");
        if (machineId != null) {
            this.logger.fine("Deploy action for instance " + path + " is cancelled in " + ma.getName() + ". Already associated with a machine.");
            return;
        }
        Instance.InstanceStatus initialStatus = scopedInstance.getStatus();
        try {
            scopedInstance.setStatus(Instance.InstanceStatus.DEPLOYING);
            this.notificationMngr.instance(scopedInstance, ma.getApplication(), EventType.CHANGED);
            Map<String, byte[]> scriptResources = this.targetsMngr.findScriptResourcesForAgent((AbstractApplication)ma.getApplication(), scopedInstance);
            MsgCmdSetScopedInstance msgModel = new MsgCmdSetScopedInstance(scopedInstance, ma.getApplication().getExternalExports(), ma.getApplication().getApplicationBindings(), scriptResources);
            this.messagingMngr.sendMessageSafely(ma, scopedInstance, (Message)msgModel);
            Map probeResources = ResourceUtils.storeInstanceProbeResources((File)ma.getDirectory(), (Instance)scopedInstance);
            if (!probeResources.isEmpty()) {
                MsgCmdUpdateProbeConfiguration msgProbes = new MsgCmdUpdateProbeConfiguration(scopedInstance, probeResources);
                this.messagingMngr.sendMessageSafely(ma, scopedInstance, (Message)msgProbes);
            }
            ITargetsMngr.TargetProperties targetProperties = this.targetsMngr.lockAndGetTarget(ma.getApplication(), scopedInstance);
            targetProperties.asMap().putAll(scopedInstance.data);
            TargetHandler targetHandler = this.targetHandlerResolver.findTargetHandler(targetProperties.asMap());
            TargetHandlerParameters parameters = this.parameters(ma, scopedInstance, targetProperties);
            try {
                machineId = targetHandler.createMachine(parameters);
            }
            catch (TargetException e) {
                this.targetsMngr.unlockTarget(ma.getApplication(), scopedInstance);
                throw e;
            }
            scopedInstance.data.put("machine.id", machineId);
            this.logger.fine("Scoped instance " + path + "'s deployment was successfully requested in " + ma.getName() + ". Machine ID: " + machineId);
            try {
                targetHandler.configureMachine(parameters, machineId);
            }
            catch (Exception e) {
                this.logger.severe("Configuration for scoped instance '" + path + "' failed in " + ma.getName() + ". " + e.getMessage());
                Utils.logException((Logger)this.logger, (Throwable)e);
                scopedInstance.setStatus(Instance.InstanceStatus.PROBLEM);
                scopedInstance.data.put("last.problem", "Machine configuration failed. Reason: " + e.getMessage());
            }
            this.logger.fine("Scoped instance " + path + "'s configuration is on its way in " + ma.getName() + ".");
            this.targetConfigurator.reportCandidate(parameters, scopedInstance);
        }
        catch (IOException | TargetException e) {
            this.logger.severe("Failed to deploy scoped instance '" + path + "' in " + ma.getName() + ". " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
            Object object2 = LOCK;
            synchronized (object2) {
                scopedInstance.data.remove("target.acquired");
            }
            scopedInstance.setStatus(initialStatus);
            throw e;
        }
        finally {
            ConfigurationUtils.saveInstances(ma);
            this.notificationMngr.instance(scopedInstance, ma.getApplication(), EventType.CHANGED);
        }
    }

    private void undeployTarget(ManagedApplication ma, Instance scopedInstance) throws TargetException, IOException {
        String path = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
        this.logger.fine("Undeploying scoped instance '" + path + "' in " + ma.getName() + "...");
        Instance.InstanceStatus initialStatus = scopedInstance.getStatus();
        String machineId = (String)scopedInstance.data.remove("machine.id");
        try {
            scopedInstance.setStatus(Instance.InstanceStatus.UNDEPLOYING);
            this.notificationMngr.instance(scopedInstance, ma.getApplication(), EventType.CHANGED);
            this.logger.fine("Agent '" + path + "' is about to be deleted in " + ma.getName() + ".");
            if (machineId != null) {
                String scopedInstancePath = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
                ITargetsMngr.TargetProperties targetProperties = this.targetsMngr.findTargetProperties((AbstractApplication)ma.getApplication(), scopedInstancePath);
                targetProperties.asMap().putAll(scopedInstance.data);
                TargetHandlerParameters parameters = this.parameters(ma, scopedInstance, targetProperties);
                this.targetConfigurator.cancelCandidate(parameters, scopedInstance);
                TargetHandler targetHandler = this.targetHandlerResolver.findTargetHandler(targetProperties.asMap());
                targetHandler.terminateMachine(parameters, machineId);
                this.releaseLockedTargets(ma.getApplication(), scopedInstance);
                this.messagingMngr.getMessagingClient().propagateAgentTermination(ma.getApplication(), scopedInstance);
            }
            this.logger.fine("Agent '" + path + "' was successfully deleted in " + ma.getName() + ".");
            DmUtils.markScopedInstanceAsNotDeployed(scopedInstance, ma, this.notificationMngr, this);
            this.logger.fine("Scoped instance " + path + "'s undeployment was successfully requested in " + ma.getName() + ".");
        }
        catch (IOException | TargetException e) {
            scopedInstance.setStatus(initialStatus);
            scopedInstance.data.put("machine.id", machineId);
            this.notificationMngr.instance(scopedInstance, ma.getApplication(), EventType.CHANGED);
            this.logger.severe("Failed to undeploy scoped instance '" + path + "' in " + ma.getName() + ". " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
            throw e;
        }
        finally {
            ma.removeAwaitingMessages(scopedInstance);
            ConfigurationUtils.saveInstances(ma);
        }
    }

    private void releaseLockedTargets(Application app, Instance instance) throws IOException {
        for (Instance i : InstanceHelpers.buildHierarchicalList((Instance)instance)) {
            if (!InstanceHelpers.isTarget((Instance)i)) continue;
            this.targetsMngr.unlockTarget(app, i);
        }
    }

    private TargetHandlerParameters parameters(ManagedApplication ma, Instance scopedInstance, ITargetsMngr.TargetProperties targetProperties) {
        Map messagingConfiguration = this.messagingMngr.getMessagingClient().getConfiguration();
        String scopedInstancePath = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
        File localExecutionScript = this.targetsMngr.findScriptForDm((AbstractApplication)ma.getApplication(), scopedInstance);
        TargetHandlerParameters parameters = new TargetHandlerParameters().targetProperties(targetProperties.asMap()).messagingProperties(messagingConfiguration).scopedInstancePath(scopedInstancePath).scopedInstance(scopedInstance).applicationName(ma.getName()).domain(this.dmDomain).targetConfigurationScript(localExecutionScript);
        if (targetProperties.getSourceFile() != null) {
            parameters.setTargetPropertiesDirectory(targetProperties.getSourceFile().getParentFile());
        }
        return parameters;
    }

    static void processExceptions(Logger logger, List<Exception> exceptions, String msg) throws IOException {
        for (Exception e : exceptions) {
            Utils.logException((Logger)logger, (Throwable)e);
        }
        if (exceptions.size() > 0) {
            logger.info(msg);
            throw new IOException(msg);
        }
    }
}

