/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.environment.messaging.RCDm;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IMessagingMngr;
import net.roboconf.messaging.api.business.IDmClient;
import net.roboconf.messaging.api.messages.Message;

public class MessagingMngrImpl
implements IMessagingMngr {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private RCDm messagingClient;

    public void setMessagingClient(RCDm messagingClient) {
        this.messagingClient = messagingClient;
    }

    @Override
    public void sendMessageSafely(ManagedApplication ma, Instance instance, Message message) {
        ma.storeAwaitingMessage(instance, message);
        this.sendStoredMessages(ma, instance);
    }

    @Override
    public void sendMessageDirectly(ManagedApplication ma, Instance scopedInstance, Message message) throws IOException {
        this.messagingClient.sendMessageToAgent(ma.getApplication(), scopedInstance, message);
    }

    @Override
    public void sendStoredMessages(ManagedApplication ma, Instance instance) {
        Instance scopedInstance;
        if (this.messagingIsReady() && (scopedInstance = InstanceHelpers.findScopedInstance((Instance)instance)).getStatus() == Instance.InstanceStatus.DEPLOYED_STARTED) {
            List<Message> messages = ma.removeAwaitingMessages(instance);
            if (messages.isEmpty()) {
                return;
            }
            String path = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
            this.logger.fine("Forcing the sending of " + messages.size() + " awaiting message(s) for " + path + ".");
            for (Message msg : messages) {
                try {
                    this.sendMessageDirectly(ma, scopedInstance, msg);
                }
                catch (IOException e) {
                    ma.storeAwaitingMessage(scopedInstance, msg);
                    this.logger.severe("Error while sending a stored message. A retry is planned. " + e.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void sendMessageToTheDm(Message message) throws IOException {
        this.messagingClient.sendMessageToTheDm(message);
    }

    @Override
    public IDmClient getMessagingClient() {
        return this.messagingClient;
    }

    @Override
    public void checkMessagingConfiguration() throws IOException {
        String msg = null;
        if (this.messagingClient == null) {
            msg = "The DM was not started.";
        } else if (!this.messagingClient.hasValidClient()) {
            msg = "The DM's configuration is invalid. Please, review the messaging settings.";
        }
        if (msg != null) {
            this.logger.warning(msg);
            throw new IOException(msg);
        }
    }

    private boolean messagingIsReady() {
        boolean result;
        boolean bl = result = this.messagingClient != null && this.messagingClient.isConnected();
        if (!result) {
            this.logger.severe("The connection with the messaging server was badly initialized. Message dropped.");
        }
        return result;
    }
}

