/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.roboconf.core.model.runtime.Preference;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.api.IPreferencesMngr;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class PreferencesMngrImpl
implements IPreferencesMngr,
Pojo {
    InstanceManager __IM;
    static final String PID = "net.roboconf.dm.preferences";
    static final IPreferencesMngr.Defaults DEFAULTS = new IPreferencesMngr.Defaults();
    private boolean __FconfigAdmin;
    private ConfigurationAdmin configAdmin;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __Fcache;
    private final ConcurrentHashMap<String, String> cache;
    boolean __MupdateProperties$java_util_Dictionary;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MsetConfigAdmin$org_osgi_service_cm_ConfigurationAdmin;
    boolean __Mget$java_lang_String;
    boolean __Mget$java_lang_String$java_lang_String;
    boolean __Msave$java_lang_String$java_lang_String;
    boolean __MaddToList$java_lang_String$java_lang_String;
    boolean __MremoveFromList$java_lang_String$java_lang_String;
    boolean __MgetAsCollection$java_lang_String;
    boolean __Mdelete$java_lang_String;
    boolean __MgetJavaxMailProperties;
    boolean __MgetAllPreferences;
    boolean __MgetPreferencesAsCollection$java_lang_String;

    ConfigurationAdmin __getconfigAdmin() {
        if (!this.__FconfigAdmin) {
            return this.configAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configAdmin");
    }

    void __setconfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigAdmin) {
            this.configAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configAdmin", (Object)configurationAdmin);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    ConcurrentHashMap __getcache() {
        if (!this.__Fcache) {
            return this.cache;
        }
        return (ConcurrentHashMap)this.__IM.onGet((Object)this, "cache");
    }

    void __setcache(ConcurrentHashMap concurrentHashMap) {
        if (!this.__Fcache) {
            this.cache = concurrentHashMap;
            return;
        }
        this.__IM.onSet((Object)this, "cache", (Object)concurrentHashMap);
    }

    public PreferencesMngrImpl() {
        this(null);
    }

    private PreferencesMngrImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
        this.__setcache(new ConcurrentHashMap());
        this.__getcache().putAll(PreferencesMngrImpl.DEFAULTS.keyToDefaultValue);
    }

    @Override
    public void updateProperties(Dictionary<?, ?> properties) {
        if (!this.__MupdateProperties$java_util_Dictionary) {
            this.__M_updateProperties(properties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateProperties$java_util_Dictionary", new Object[]{properties});
            this.__M_updateProperties(properties);
            this.__IM.onExit((Object)this, "updateProperties$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateProperties$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_updateProperties(Dictionary<?, ?> properties) {
        List<String> propertiesToSkip = Arrays.asList("component", "felix.fileinstall.filename");
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> en = properties.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            String keyAsString = String.valueOf(key);
            if (propertiesToSkip.contains(keyAsString)) continue;
            Object value = properties.get(key);
            map.put(keyAsString, String.valueOf(value));
        }
        this.__getcache().clear();
        this.__getcache().putAll(map);
        this.__getlogger().fine("Preferences were updated in bulk mode.");
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        this.__getlogger().info("The DM preferences were started.");
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__getlogger().info("The DM preferences were stopped.");
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        if (!this.__MsetConfigAdmin$org_osgi_service_cm_ConfigurationAdmin) {
            this.__M_setConfigAdmin(configAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigAdmin$org_osgi_service_cm_ConfigurationAdmin", new Object[]{configAdmin});
            this.__M_setConfigAdmin(configAdmin);
            this.__IM.onExit((Object)this, "setConfigAdmin$org_osgi_service_cm_ConfigurationAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigAdmin$org_osgi_service_cm_ConfigurationAdmin", throwable);
            throw throwable;
        }
    }

    private void __M_setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.__setconfigAdmin(configAdmin);
    }

    @Override
    public String get(String key) {
        String string;
        if (!this.__Mget$java_lang_String) {
            return this.__M_get(key);
        }
        try {
            this.__IM.onEntry((Object)this, "get$java_lang_String", new Object[]{key});
            string = this.__M_get(key);
            this.__IM.onExit((Object)this, "get$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "get$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_get(String key) {
        return (String)this.__getcache().get(key);
    }

    @Override
    public String get(String key, String defaultValue) {
        String string;
        if (!this.__Mget$java_lang_String$java_lang_String) {
            return this.__M_get(key, defaultValue);
        }
        try {
            this.__IM.onEntry((Object)this, "get$java_lang_String$java_lang_String", new Object[]{key, defaultValue});
            string = this.__M_get(key, defaultValue);
            this.__IM.onExit((Object)this, "get$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "get$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_get(String key, String defaultValue) {
        return this.__getcache().containsKey(key) ? (String)this.__getcache().get(key) : defaultValue;
    }

    @Override
    public void save(String key, String value) throws IOException {
        if (!this.__Msave$java_lang_String$java_lang_String) {
            this.__M_save(key, value);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "save$java_lang_String$java_lang_String", new Object[]{key, value});
            this.__M_save(key, value);
            this.__IM.onExit((Object)this, "save$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "save$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_save(String key, String value) throws IOException {
        this.__getlogger().fine("Preference with key '" + key + "' is being updated.");
        this.__getlogger().finest("New preference value: " + key + " = " + value);
        String realValue = value == null ? "" : value;
        this.__getcache().put(key, realValue);
        if (this.__getconfigAdmin() != null) {
            Configuration config = this.__getconfigAdmin().getConfiguration(PID, null);
            Dictionary props = config.getProperties();
            props.put(key, realValue);
            config.update(props);
        } else {
            this.__getlogger().warning("Config Admin is not available.");
        }
    }

    @Override
    public void addToList(String key, String value) throws IOException {
        if (!this.__MaddToList$java_lang_String$java_lang_String) {
            this.__M_addToList(key, value);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addToList$java_lang_String$java_lang_String", new Object[]{key, value});
            this.__M_addToList(key, value);
            this.__IM.onExit((Object)this, "addToList$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addToList$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_addToList(String key, String value) throws IOException {
        Set<String> values = this.getPreferencesAsCollection(key);
        values.add(value);
        this.save(key, Utils.format(values, (String)", "));
    }

    @Override
    public void removeFromList(String key, String value) throws IOException {
        if (!this.__MremoveFromList$java_lang_String$java_lang_String) {
            this.__M_removeFromList(key, value);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeFromList$java_lang_String$java_lang_String", new Object[]{key, value});
            this.__M_removeFromList(key, value);
            this.__IM.onExit((Object)this, "removeFromList$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeFromList$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_removeFromList(String key, String value) throws IOException {
        Set<String> values = this.getPreferencesAsCollection(key);
        values.remove(value);
        this.save(key, Utils.format(values, (String)", "));
    }

    @Override
    public Collection<String> getAsCollection(String key) {
        Collection<String> collection;
        if (!this.__MgetAsCollection$java_lang_String) {
            return this.__M_getAsCollection(key);
        }
        try {
            this.__IM.onEntry((Object)this, "getAsCollection$java_lang_String", new Object[]{key});
            collection = this.__M_getAsCollection(key);
            this.__IM.onExit((Object)this, "getAsCollection$java_lang_String", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAsCollection$java_lang_String", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<String> __M_getAsCollection(String key) {
        return this.getPreferencesAsCollection(key);
    }

    @Override
    public String delete(String key) {
        String string;
        if (!this.__Mdelete$java_lang_String) {
            return this.__M_delete(key);
        }
        try {
            this.__IM.onEntry((Object)this, "delete$java_lang_String", new Object[]{key});
            string = this.__M_delete(key);
            this.__IM.onExit((Object)this, "delete$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "delete$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_delete(String key) {
        return (String)this.__getcache().remove(key);
    }

    @Override
    public Properties getJavaxMailProperties() {
        Properties properties;
        if (!this.__MgetJavaxMailProperties) {
            return this.__M_getJavaxMailProperties();
        }
        try {
            this.__IM.onEntry((Object)this, "getJavaxMailProperties", new Object[0]);
            properties = this.__M_getJavaxMailProperties();
            this.__IM.onExit((Object)this, "getJavaxMailProperties", (Object)properties);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJavaxMailProperties", throwable);
            throw throwable;
        }
        return properties;
    }

    private Properties __M_getJavaxMailProperties() {
        Properties result = new Properties();
        for (Map.Entry entry : this.__getcache().entrySet()) {
            if (!((String)entry.getKey()).startsWith("mail.")) continue;
            result.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    @Override
    public List<Preference> getAllPreferences() {
        List<Preference> list;
        if (!this.__MgetAllPreferences) {
            return this.__M_getAllPreferences();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllPreferences", new Object[0]);
            list = this.__M_getAllPreferences();
            this.__IM.onExit((Object)this, "getAllPreferences", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllPreferences", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Preference> __M_getAllPreferences() {
        ArrayList<Preference> result = new ArrayList<Preference>();
        for (Map.Entry entry : this.__getcache().entrySet()) {
            Preference.PreferenceKeyCategory category = PreferencesMngrImpl.DEFAULTS.keyToCategory.get(entry.getKey());
            Preference p = new Preference((String)entry.getKey(), (String)entry.getValue(), category);
            result.add(p);
        }
        return result;
    }

    private Set<String> getPreferencesAsCollection(String key) {
        Set<String> set;
        if (!this.__MgetPreferencesAsCollection$java_lang_String) {
            return this.__M_getPreferencesAsCollection(key);
        }
        try {
            this.__IM.onEntry((Object)this, "getPreferencesAsCollection$java_lang_String", new Object[]{key});
            set = this.__M_getPreferencesAsCollection(key);
            this.__IM.onExit((Object)this, "getPreferencesAsCollection$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPreferencesAsCollection$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __M_getPreferencesAsCollection(String key) {
        String listAsString = this.get(key, "");
        List list = Utils.filterEmptyValues((List)Utils.splitNicely((String)listAsString, (String)","));
        return new LinkedHashSet<String>(list);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("cache")) {
                this.__Fcache = true;
            }
            if (set.contains("configAdmin")) {
                this.__FconfigAdmin = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("updateProperties$java_util_Dictionary")) {
                this.__MupdateProperties$java_util_Dictionary = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("setConfigAdmin$org_osgi_service_cm_ConfigurationAdmin")) {
                this.__MsetConfigAdmin$org_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("get$java_lang_String")) {
                this.__Mget$java_lang_String = true;
            }
            if (set.contains("get$java_lang_String$java_lang_String")) {
                this.__Mget$java_lang_String$java_lang_String = true;
            }
            if (set.contains("save$java_lang_String$java_lang_String")) {
                this.__Msave$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addToList$java_lang_String$java_lang_String")) {
                this.__MaddToList$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeFromList$java_lang_String$java_lang_String")) {
                this.__MremoveFromList$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getAsCollection$java_lang_String")) {
                this.__MgetAsCollection$java_lang_String = true;
            }
            if (set.contains("delete$java_lang_String")) {
                this.__Mdelete$java_lang_String = true;
            }
            if (set.contains("getJavaxMailProperties")) {
                this.__MgetJavaxMailProperties = true;
            }
            if (set.contains("getAllPreferences")) {
                this.__MgetAllPreferences = true;
            }
            if (set.contains("getPreferencesAsCollection$java_lang_String")) {
                this.__MgetPreferencesAsCollection$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

