/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.userdata.UserDataHelpers;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.api.ITargetConfigurator;
import net.roboconf.dm.management.api.ITargetHandlerResolver;
import net.roboconf.target.api.TargetHandler;
import net.roboconf.target.api.TargetHandlerParameters;

public class TargetConfiguratorImpl
implements ITargetConfigurator {
    ExecutorService executor;
    final Map<String, TargetConfiugrationBean> candidates = new ConcurrentHashMap<String, TargetConfiugrationBean>();
    private ITargetHandlerResolver targetHandlerResolver;

    @Override
    public void start() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    public void setTargetHandlerResolver(ITargetHandlerResolver targetHandlerResolver) {
        this.targetHandlerResolver = targetHandlerResolver;
    }

    @Override
    public void reportCandidate(TargetHandlerParameters parameters, Instance scopedInstance) {
        String key = parameters.getApplicationName() + "_" + parameters.getScopedInstancePath();
        this.candidates.put(key, new TargetConfiugrationBean(parameters, scopedInstance));
    }

    @Override
    public void cancelCandidate(TargetHandlerParameters parameters, Instance scopedInstance) {
        String key = parameters.getApplicationName() + "_" + parameters.getScopedInstancePath();
        this.candidates.remove(key);
    }

    @Override
    public void verifyCandidates() {
        if (this.executor == null) {
            return;
        }
        for (Map.Entry<String, TargetConfiugrationBean> entry : this.candidates.entrySet()) {
            Instance scopedInstance = entry.getValue().scopedInstance;
            TargetHandlerParameters parameters = entry.getValue().parameters;
            File script = parameters.getTargetConfigurationScript();
            if (!scopedInstance.data.containsKey("ready.for.local.script.configuration")) continue;
            scopedInstance.data.remove("ready.for.local.script.configuration");
            if (script != null && script.exists() && this.targetHandlerResolver != null) {
                this.executor.execute(new ConfigurationRunnable(parameters, scopedInstance, this.targetHandlerResolver));
            }
            this.candidates.remove(entry.getKey());
        }
    }

    static class ConfigurationRunnable
    implements Runnable {
        private final Logger logger = Logger.getLogger(this.getClass().getName());
        private final TargetHandlerParameters parameters;
        private final ITargetHandlerResolver targetHandlerResolver;
        private final Instance scopedInstance;
        ProgramUtilsProxy programUtils;

        public ConfigurationRunnable(TargetHandlerParameters parameters, Instance scopedInstance, ITargetHandlerResolver targetHandlerResolver) {
            this.parameters = parameters;
            this.scopedInstance = scopedInstance;
            this.targetHandlerResolver = targetHandlerResolver;
            this.programUtils = new ProgramUtilsProxy();
        }

        @Override
        public void run() {
            String suffix = this.parameters.getScopedInstancePath() + " in " + this.parameters.getApplicationName();
            try {
                File script;
                String publicIpAddress;
                TargetHandler th = this.targetHandlerResolver.findTargetHandler(this.parameters.getTargetProperties());
                String machineId = (String)this.scopedInstance.data.get("machine.id");
                if (Utils.isEmptyOrWhitespaces((String)machineId)) {
                    this.logger.warning("No machine ID was found for " + suffix);
                }
                if (Utils.isEmptyOrWhitespaces((String)(publicIpAddress = th.retrievePublicIpAddress(this.parameters, machineId)))) {
                    publicIpAddress = "";
                    this.logger.warning("No public IP address could be retrieved for " + suffix);
                }
                if ((script = this.parameters.getTargetConfigurationScript()).exists()) {
                    script.setExecutable(true);
                    String[] command = new String[]{script.getAbsolutePath()};
                    String userData = UserDataHelpers.writeUserDataAsString((Map)this.parameters.getMessagingProperties(), (String)this.parameters.getDomain(), (String)this.parameters.getApplicationName(), (String)this.parameters.getScopedInstancePath());
                    HashMap<String, String> vars = new HashMap<String, String>();
                    vars.put("IP_ADDRESS", publicIpAddress);
                    vars.put("APPLICATION_NAME", this.parameters.getApplicationName());
                    vars.put("SCOPED_INSTANCE_PATH", this.parameters.getScopedInstancePath());
                    vars.put("DOMAIN", this.parameters.getDomain());
                    vars.put("USER_DATA", userData);
                    this.programUtils.executeCommand(this.logger, command, script.getParentFile(), vars, this.parameters.getApplicationName(), this.parameters.getScopedInstancePath());
                }
            }
            catch (Throwable t) {
                this.logger.severe("Failed to run local configuration script for target " + suffix);
                Utils.logException((Logger)this.logger, (Throwable)t);
            }
        }
    }

    static class ProgramUtilsProxy {
        ProgramUtilsProxy() {
        }

        int executeCommand(Logger logger, String[] command, File workingDir, Map<String, String> environmentVars, String applicationName, String scopedInstancePath) throws IOException, InterruptedException {
            return ProgramUtils.executeCommand((Logger)logger, (String[])command, (File)workingDir, environmentVars, (String)applicationName, (String)scopedInstancePath);
        }
    }

    static class TargetConfiugrationBean {
        private final TargetHandlerParameters parameters;
        private final Instance scopedInstance;

        public TargetConfiugrationBean(TargetHandlerParameters parameters, Instance scopedInstance) {
            this.parameters = parameters;
            this.scopedInstance = scopedInstance;
        }
    }
}

