/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.dm.internal.utils.TargetHelpers;
import net.roboconf.dm.management.api.ITargetHandlerResolver;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandler;

public class TargetHandlerResolverImpl
implements ITargetHandlerResolver {
    private final List<TargetHandler> targetHandlers = new ArrayList<TargetHandler>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetHandler(TargetHandler targetItf) {
        if (targetItf != null) {
            this.logger.info("Target handler '" + targetItf.getTargetId() + "' is now available in Roboconf's DM.");
            List<TargetHandler> list = this.targetHandlers;
            synchronized (list) {
                this.targetHandlers.add(targetItf);
            }
            TargetHandlerResolverImpl.listTargets(this.targetHandlers, this.logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetHandler(TargetHandler targetItf) {
        if (targetItf == null) {
            this.logger.info("An invalid target handler is removed.");
        } else {
            List<TargetHandler> list = this.targetHandlers;
            synchronized (list) {
                this.targetHandlers.remove(targetItf);
            }
            this.logger.info("Target handler '" + targetItf.getTargetId() + "' is not available anymore in Roboconf's DM.");
        }
        TargetHandlerResolverImpl.listTargets(this.targetHandlers, this.logger);
    }

    @Override
    public TargetHandler findTargetHandler(Map<String, String> targetProperties) throws TargetException {
        String targetId = TargetHelpers.findTargetHandlerName(targetProperties);
        TargetHandler result = null;
        if (targetId != null) {
            for (TargetHandler itf : this.targetHandlers) {
                if (!targetId.equalsIgnoreCase(itf.getTargetId())) continue;
                result = itf;
                break;
            }
        }
        if (result == null) {
            throw new TargetException("No deployment handler was found for handler named " + targetId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetHandler> getTargetHandlersSnapshot() {
        ArrayList<TargetHandler> snapshot;
        List<TargetHandler> list = this.targetHandlers;
        synchronized (list) {
            snapshot = new ArrayList<TargetHandler>(this.targetHandlers);
        }
        return snapshot;
    }

    public static void listTargets(List<TargetHandler> targetHandlers, Logger logger) {
        if (targetHandlers.isEmpty()) {
            logger.info("No target was found for Roboconf's DM.");
        } else {
            StringBuilder sb = new StringBuilder("Available target in Roboconf's DM: ");
            Iterator<TargetHandler> it = targetHandlers.iterator();
            while (it.hasNext()) {
                sb.append(it.next().getTargetId());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(".");
            logger.info(sb.toString());
        }
    }
}

