/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.TargetValidator;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.TargetUsageItem;
import net.roboconf.core.model.runtime.TargetWrapperDescriptor;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.api.impl.beans.InstanceContext;
import net.roboconf.dm.internal.api.impl.beans.TargetPropertiesImpl;
import net.roboconf.dm.internal.utils.TargetHelpers;
import net.roboconf.dm.management.api.IConfigurationMngr;
import net.roboconf.dm.management.api.ITargetsMngr;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;

public class TargetsMngrImpl
implements ITargetsMngr {
    private static final String TARGETS_ASSOC_FILE = "associations.properties";
    private static final String TARGETS_HINTS_FILE = "hints.properties";
    private static final String TARGETS_USAGE_FILE = "usage.properties";
    private static final String CREATED_BY = "created.from";
    private static final Object LOCK = new Object();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final IConfigurationMngr configurationMngr;
    private final Map<InstanceContext, String> instanceToCachedId;
    final ConcurrentHashMap<String, Boolean> targetIds = new ConcurrentHashMap();

    public TargetsMngrImpl(IConfigurationMngr configurationMngr) {
        this.configurationMngr = configurationMngr;
        this.instanceToCachedId = new ConcurrentHashMap<InstanceContext, String>();
        this.restoreAssociationsCache();
    }

    @Override
    public String createTarget(String targetContent) throws IOException {
        TargetValidator tv = new TargetValidator(targetContent);
        tv.validate();
        if (RoboconfErrorHelpers.containsCriticalErrors((Collection)tv.getErrors())) {
            throw new IOException("There are errors in the target definition.");
        }
        String targetId = tv.getProperties().getProperty("id");
        String creator = tv.getProperties().getProperty(CREATED_BY);
        if (this.targetIds.putIfAbsent(targetId, Boolean.TRUE) != null) {
            if (creator == null) {
                throw new IOException("ID " + targetId + " is already used.");
            }
            File createdByFile = new File(this.findTargetDirectory(targetId), CREATED_BY);
            String storedCreator = null;
            if (createdByFile.exists()) {
                storedCreator = Utils.readFileContent((File)createdByFile);
            }
            if (!Objects.equals(creator, storedCreator)) {
                throw new IOException("ID " + targetId + " is already used.");
            }
        }
        targetContent = targetContent.replaceAll("id\\s*(:|=)[^\n]*(\n|$)", "");
        targetContent = targetContent.replaceAll("\n\n" + Pattern.quote(CREATED_BY) + "\\s*(:|=)[^\n]*(\n|$)", "");
        File targetFile = new File(this.findTargetDirectory(targetId), "target.properties");
        Utils.createDirectory((File)targetFile.getParentFile());
        Utils.writeStringInto((String)targetContent, (File)targetFile);
        if (creator != null) {
            File createdByFile = new File(this.findTargetDirectory(targetId), CREATED_BY);
            Utils.writeStringInto((String)creator, (File)createdByFile);
        }
        return targetId;
    }

    @Override
    public String createTarget(File targetPropertiesFile, ApplicationTemplate creator) throws IOException {
        String fileContent = Utils.readFileContent((File)targetPropertiesFile);
        StringBuilder sb = new StringBuilder(fileContent);
        if (creator != null) {
            sb.append("\n\n");
            sb.append(CREATED_BY);
            sb.append(": ");
            sb.append(creator.getName());
            sb.append(" - ");
            sb.append(creator.getVersion());
        }
        String targetId = this.createTarget(sb.toString());
        String prefix = Utils.removeFileExtension((String)targetPropertiesFile.getName());
        File scriptsInDir = new File(targetPropertiesFile.getParentFile(), prefix);
        File scriptsOutDir = new File(this.findTargetDirectory(targetId), "scripts");
        List scriptFiles = scriptsInDir.exists() ? Utils.listAllFiles((File)scriptsInDir) : Collections.emptyList();
        if (!scriptFiles.isEmpty()) {
            Utils.createDirectory((File)scriptsOutDir);
            for (File inputFile : scriptFiles) {
                String relativePath = Utils.computeFileRelativeLocation((File)scriptsInDir, (File)inputFile);
                File outputFile = new File(scriptsOutDir, relativePath);
                Utils.createDirectory((File)outputFile.getParentFile());
                Utils.copyStream((File)inputFile, (File)outputFile);
            }
        }
        return targetId;
    }

    @Override
    public void updateTarget(String targetId, String newTargetContent) throws IOException, UnauthorizedActionException {
        TargetValidator tv = new TargetValidator(newTargetContent);
        tv.validate();
        RoboconfErrorHelpers.filterErrors((Collection)tv.getErrors(), (ErrorCode[])new ErrorCode[]{ErrorCode.REC_TARGET_NO_ID, ErrorCode.REC_TARGET_CONFLICTING_ID});
        if (RoboconfErrorHelpers.containsCriticalErrors((Collection)tv.getErrors())) {
            throw new IOException("There are errors in the target definition.");
        }
        File targetFile = this.findTargetFile(targetId, "target.properties");
        if (targetFile == null) {
            throw new UnauthorizedActionException("Target " + targetId + " does not exist.");
        }
        Utils.writeStringInto((String)newTargetContent, (File)targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTarget(String targetId) throws IOException, UnauthorizedActionException {
        boolean used = false;
        Object object = LOCK;
        synchronized (object) {
            used = this.isTargetUsed(targetId);
        }
        if (used) {
            throw new UnauthorizedActionException("Deletion is not permitted.");
        }
        this.targetIds.remove(targetId);
        File targetDirectory = this.findTargetDirectory(targetId);
        Utils.deleteFilesRecursively((File[])new File[]{targetDirectory});
    }

    @Override
    public void associateTargetWith(String targetId, AbstractApplication app, String instancePathOrComponentName) throws IOException, UnauthorizedActionException {
        boolean valid = false;
        if (instancePathOrComponentName == null) {
            valid = true;
        } else if (instancePathOrComponentName.startsWith("@")) {
            Component comp = ComponentHelpers.findComponent((AbstractApplication)app, (String)instancePathOrComponentName.substring(1));
            valid = comp != null;
        } else {
            Instance instance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePathOrComponentName);
            boolean bl = valid = instance != null;
            if (instance != null) {
                if (instance.getStatus() != Instance.InstanceStatus.NOT_DEPLOYED) {
                    throw new UnauthorizedActionException("Operation not allowed: " + app + " :: " + instancePathOrComponentName + " should be not deployed.");
                }
                if (!InstanceHelpers.isTarget((Instance)instance)) {
                    throw new IllegalArgumentException("Only scoped instances can be associated with targets. Path in error: " + instancePathOrComponentName);
                }
            }
        }
        if (valid) {
            this.saveAssociation(app, targetId, instancePathOrComponentName, true);
        }
    }

    @Override
    public void dissociateTargetFrom(AbstractApplication app, String instancePathOrComponentName) throws IOException, UnauthorizedActionException {
        Instance instance;
        if (instancePathOrComponentName != null && !instancePathOrComponentName.startsWith("@") && (instance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePathOrComponentName)) != null) {
            if (instance.getStatus() != Instance.InstanceStatus.NOT_DEPLOYED) {
                throw new UnauthorizedActionException("Operation not allowed: " + app + " :: " + instancePathOrComponentName + " should be not deployed.");
            }
            if (!InstanceHelpers.isTarget((Instance)instance)) {
                throw new IllegalArgumentException("Only scoped instances can be associated with targets. Path in error: " + instancePathOrComponentName);
            }
        }
        this.saveAssociation(app, null, instancePathOrComponentName, false);
    }

    @Override
    public void copyOriginalMapping(Application app) throws IOException {
        ArrayList<InstanceContext> keys = new ArrayList<InstanceContext>();
        keys.add(new InstanceContext((AbstractApplication)app.getTemplate(), (String)null));
        for (Instance scopedInstance : InstanceHelpers.findAllScopedInstances((AbstractApplication)app)) {
            keys.add(new InstanceContext((AbstractApplication)app.getTemplate(), scopedInstance));
        }
        for (Component comp : ComponentHelpers.findAllComponents((AbstractApplication)app)) {
            if (!ComponentHelpers.isTarget((Component)comp)) continue;
            keys.add(new InstanceContext((AbstractApplication)app.getTemplate(), "@" + comp.getName()));
        }
        for (InstanceContext key : keys) {
            String targetId = this.instanceToCachedId.get(key);
            try {
                if (targetId == null) continue;
                this.associateTargetWith(targetId, (AbstractApplication)app, key.getInstancePathOrComponentName());
            }
            catch (UnauthorizedActionException e) {
                this.logger.severe(e.getMessage());
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }

    @Override
    public void applicationWasDeleted(AbstractApplication app) throws IOException {
        String name = app.getName();
        String qualifier = app instanceof ApplicationTemplate ? ((ApplicationTemplate)app).getVersion() : null;
        ArrayList<InstanceContext> toClean = new ArrayList<InstanceContext>();
        HashSet<String> targetIds = new HashSet<String>();
        for (Map.Entry<InstanceContext, String> entry : this.instanceToCachedId.entrySet()) {
            if (!Objects.equals(name, entry.getKey().getName()) || !Objects.equals(qualifier, entry.getKey().getQualifier())) continue;
            targetIds.add(entry.getValue());
            toClean.add(entry.getKey());
        }
        for (Instance scopedInstance : InstanceHelpers.findAllScopedInstances((AbstractApplication)app)) {
            InstanceContext ctx = new InstanceContext(app, scopedInstance);
            toClean.add(ctx);
        }
        for (String targetId : targetIds) {
            File[] files;
            File targetDirectory = this.findTargetDirectory(targetId);
            for (File f : files = new File[]{new File(targetDirectory, TARGETS_ASSOC_FILE), new File(targetDirectory, TARGETS_HINTS_FILE), new File(targetDirectory, TARGETS_USAGE_FILE)}) {
                for (InstanceContext key : toClean) {
                    Properties props = Utils.readPropertiesFileQuietly((File)f, (Logger)this.logger);
                    props.remove(key.toString());
                    this.writeProperties(props, f);
                }
            }
        }
        for (InstanceContext key : toClean) {
            this.instanceToCachedId.remove(key);
        }
    }

    @Override
    public ITargetsMngr.TargetProperties findTargetProperties(AbstractApplication app, String instancePath) {
        String targetId = this.findTargetId(app, instancePath);
        return this.findTargetProperties(targetId);
    }

    @Override
    public ITargetsMngr.TargetProperties findTargetProperties(String targetId) {
        File file = this.findTargetFile(targetId, "target.properties");
        String content = Utils.readFileContentQuietly((File)file, (Logger)this.logger);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : Utils.readPropertiesQuietly((String)content, (Logger)this.logger).entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return new TargetPropertiesImpl(map, content, file);
    }

    @Override
    public String findTargetId(AbstractApplication app, String instancePath, boolean strict) {
        InstanceContext key = new InstanceContext(app, instancePath);
        String targetId = this.instanceToCachedId.get(key);
        Instance inst = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePath);
        if (inst != null && !InstanceHelpers.isTarget((Instance)inst)) {
            throw new IllegalArgumentException("Targets aimed at being queried for scoped instances only. Invalid path: " + instancePath);
        }
        if (targetId == null && !strict && inst != null) {
            key = new InstanceContext(app, "@" + inst.getComponent().getName());
            targetId = this.instanceToCachedId.get(key);
        }
        if (targetId == null && !strict) {
            key = new InstanceContext(app, (String)null);
            targetId = this.instanceToCachedId.get(key);
        }
        return targetId;
    }

    @Override
    public String findTargetId(AbstractApplication app, String instancePath) {
        return this.findTargetId(app, instancePath, false);
    }

    @Override
    public Map<String, byte[]> findScriptResourcesForAgent(String targetId) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>(0);
        File targetDir = new File(this.findTargetDirectory(targetId), "scripts");
        if (targetDir.isDirectory()) {
            List<String> exclusionPatterns = Arrays.asList("(?i).*" + Pattern.quote("local.") + ".*");
            result.putAll(Utils.storeDirectoryResourcesAsBytes((File)targetDir, exclusionPatterns));
        }
        return result;
    }

    @Override
    public Map<String, byte[]> findScriptResourcesForAgent(AbstractApplication app, Instance scopedInstance) throws IOException {
        Map<String, byte[]> result = new HashMap<String, byte[]>();
        String targetId = this.findTargetId(app, InstanceHelpers.computeInstancePath((Instance)scopedInstance));
        if (targetId != null) {
            result = this.findScriptResourcesForAgent(targetId);
        }
        return result;
    }

    @Override
    public File findScriptForDm(AbstractApplication app, Instance scopedInstance) {
        File targetDir;
        File result = null;
        String targetId = this.findTargetId(app, InstanceHelpers.computeInstancePath((Instance)scopedInstance));
        if (targetId != null && (targetDir = new File(this.findTargetDirectory(targetId), "scripts")).isDirectory()) {
            for (File f : Utils.listAllFiles((File)targetDir)) {
                if (!f.getName().toLowerCase().contains("dm.configure.script.")) continue;
                result = f;
                break;
            }
        }
        return result;
    }

    @Override
    public List<TargetWrapperDescriptor> listAllTargets() {
        File dir = new File(this.configurationMngr.getWorkingDirectory(), "targets");
        List targetDirectories = Utils.listDirectories((File)dir);
        return this.buildList(targetDirectories, null);
    }

    @Override
    public TargetWrapperDescriptor findTargetById(String targetId) {
        File dir = new File(this.configurationMngr.getWorkingDirectory(), "targets");
        File targetDirectory = new File(dir, targetId);
        return this.build(targetDirectory);
    }

    @Override
    public List<TargetWrapperDescriptor> listPossibleTargets(AbstractApplication app) {
        String key = new InstanceContext(app).toString();
        String tplKey = null;
        if (app instanceof Application) {
            tplKey = new InstanceContext((AbstractApplication)((Application)app).getTemplate()).toString();
        }
        ArrayList<File> targetDirectories = new ArrayList<File>();
        File dir = new File(this.configurationMngr.getWorkingDirectory(), "targets");
        for (File f : Utils.listDirectories((File)dir)) {
            File hintsFile = new File(f, TARGETS_HINTS_FILE);
            if (!hintsFile.exists()) {
                targetDirectories.add(f);
                continue;
            }
            Properties props = Utils.readPropertiesFileQuietly((File)hintsFile, (Logger)this.logger);
            if (props.containsKey(key)) {
                targetDirectories.add(f);
                continue;
            }
            if (tplKey == null || !props.containsKey(tplKey)) continue;
            targetDirectories.add(f);
        }
        return this.buildList(targetDirectories, app);
    }

    @Override
    public void addHint(String targetId, AbstractApplication app) throws IOException {
        this.saveHint(targetId, app, true);
    }

    @Override
    public void removeHint(String targetId, AbstractApplication app) throws IOException {
        this.saveHint(targetId, app, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITargetsMngr.TargetProperties lockAndGetTarget(Application app, Instance scopedInstance) throws IOException {
        String instancePath = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
        String targetId = this.findTargetId((AbstractApplication)app, instancePath);
        if (targetId == null) {
            throw new IOException("No target was found for " + app + " :: " + instancePath);
        }
        InstanceContext mappingKey = new InstanceContext((AbstractApplication)app, instancePath);
        Object object = LOCK;
        synchronized (object) {
            this.saveUsage(mappingKey, targetId, true);
        }
        this.logger.fine("Target " + targetId + "'s lock was acquired for " + instancePath);
        ITargetsMngr.TargetProperties result = this.findTargetProperties((AbstractApplication)app, instancePath);
        Map<String, String> newTargetProperties = TargetHelpers.expandProperties(scopedInstance, result.asMap());
        result.asMap().clear();
        result.asMap().putAll(newTargetProperties);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockTarget(Application app, Instance scopedInstance) throws IOException {
        String instancePath = InstanceHelpers.computeInstancePath((Instance)scopedInstance);
        String targetId = this.findTargetId((AbstractApplication)app, instancePath);
        InstanceContext mappingKey = new InstanceContext((AbstractApplication)app, instancePath);
        Object object = LOCK;
        synchronized (object) {
            this.saveUsage(mappingKey, targetId, false);
        }
        this.logger.fine("Target " + targetId + "'s lock was released for " + instancePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TargetUsageItem> findUsageStatistics(String targetId) {
        List<String> appNames;
        Object object = LOCK;
        synchronized (object) {
            appNames = this.applicationsThatUse(targetId);
        }
        HashSet<TargetUsageItem> result = new HashSet<TargetUsageItem>();
        for (Map.Entry<InstanceContext, String> entry : this.instanceToCachedId.entrySet()) {
            if (!entry.getValue().equals(targetId)) continue;
            String appName = entry.getKey().getName();
            TargetUsageItem item = new TargetUsageItem();
            item.setName(appName);
            item.setVersion(entry.getKey().getQualifier());
            item.setReferencing(true);
            item.setUsing(appNames.contains(appName));
            result.add(item);
        }
        return new ArrayList<TargetUsageItem>(result);
    }

    List<TargetWrapperDescriptor> buildList(List<File> targetDirectories, AbstractApplication app) {
        ArrayList<TargetWrapperDescriptor> result = new ArrayList<TargetWrapperDescriptor>();
        for (File targetDirectory : targetDirectories) {
            TargetWrapperDescriptor tb;
            File associationFile = new File(targetDirectory, TARGETS_ASSOC_FILE);
            Properties props = Utils.readPropertiesFileQuietly((File)associationFile, (Logger)this.logger);
            boolean isDefault = false;
            if (app != null) {
                isDefault = props.containsKey(new InstanceContext(app).toString());
            }
            if ((tb = this.build(targetDirectory)) == null) continue;
            tb.setDefault(isDefault);
            result.add(tb);
        }
        return result;
    }

    TargetWrapperDescriptor build(File targetDirectory) {
        TargetWrapperDescriptor tb = null;
        File targetPropertiesFile = new File(targetDirectory, "target.properties");
        try {
            Properties props = Utils.readPropertiesFile((File)targetPropertiesFile);
            tb = new TargetWrapperDescriptor();
            tb.setId(targetDirectory.getName());
            tb.setName(props.getProperty("name"));
            tb.setDescription(props.getProperty("description"));
            String handler = TargetHelpers.findTargetHandlerName(props);
            tb.setHandler(handler);
        }
        catch (IOException e) {
            this.logger.severe("Properties of the target #" + targetDirectory.getName() + " could not be read.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return tb;
    }

    private void saveAssociation(AbstractApplication app, String targetId, String instancePathOrComponentName, boolean add) throws IOException {
        String oldTargetId;
        InstanceContext key = new InstanceContext(app, instancePathOrComponentName);
        if (instancePathOrComponentName != null && (oldTargetId = this.instanceToCachedId.remove(key)) != null) {
            File associationFile = this.findTargetFile(oldTargetId, TARGETS_ASSOC_FILE);
            Properties props = Utils.readPropertiesFileQuietly((File)associationFile, (Logger)this.logger);
            props.remove(key.toString());
            this.writeProperties(props, associationFile);
        }
        if (add) {
            File associationFile = this.findTargetFile(targetId, TARGETS_ASSOC_FILE);
            if (associationFile == null) {
                throw new IOException("Target " + targetId + " does not exist.");
            }
            Properties props = Utils.readPropertiesFileQuietly((File)associationFile, (Logger)this.logger);
            props.setProperty(key.toString(), "");
            this.writeProperties(props, associationFile);
            this.instanceToCachedId.put(key, targetId);
        }
    }

    private void restoreAssociationsCache() {
        File dir = new File(this.configurationMngr.getWorkingDirectory(), "targets");
        for (File f : Utils.listDirectories((File)dir)) {
            this.targetIds.put(f.getName(), Boolean.TRUE);
            File associationFile = new File(f, TARGETS_ASSOC_FILE);
            Properties props = Utils.readPropertiesFileQuietly((File)associationFile, (Logger)this.logger);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                InstanceContext key = InstanceContext.parse(entry.getKey().toString());
                this.instanceToCachedId.put(key, f.getName());
            }
        }
    }

    private void saveUsage(InstanceContext mappingKey, String targetId, boolean add) throws IOException {
        File usageFile = this.findTargetFile(targetId, TARGETS_USAGE_FILE);
        Properties props = Utils.readPropertiesFileQuietly((File)usageFile, (Logger)this.logger);
        String key = mappingKey.toString();
        if (add) {
            props.setProperty(key, targetId);
        } else {
            props.remove(key);
        }
        this.writeProperties(props, usageFile);
    }

    private boolean isTargetUsed(String targetId) {
        File usageFile = this.findTargetFile(targetId, TARGETS_USAGE_FILE);
        Properties props = Utils.readPropertiesFileQuietly((File)usageFile, (Logger)this.logger);
        boolean found = false;
        Iterator<Object> it = props.values().iterator();
        while (it.hasNext() && !found) {
            found = it.next().equals(targetId);
        }
        return found;
    }

    private List<String> applicationsThatUse(String targetId) {
        File usageFile = this.findTargetFile(targetId, TARGETS_USAGE_FILE);
        Properties props = Utils.readPropertiesFileQuietly((File)usageFile, (Logger)this.logger);
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : props.keySet()) {
            InstanceContext key = InstanceContext.parse((String)o);
            result.add(key.getName());
        }
        return result;
    }

    private void saveHint(String targetId, AbstractApplication app, boolean add) throws IOException {
        File hintsFile = this.findTargetFile(targetId, TARGETS_HINTS_FILE);
        Properties props = Utils.readPropertiesFileQuietly((File)hintsFile, (Logger)this.logger);
        String key = new InstanceContext(app).toString();
        if (add) {
            props.setProperty(key, "");
        } else {
            props.remove(key);
        }
        this.writeProperties(props, hintsFile);
    }

    private void writeProperties(Properties props, File file) throws IOException {
        if (props.isEmpty()) {
            Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{file});
        } else {
            Utils.writePropertiesFile((Properties)props, (File)file);
        }
    }

    private File findTargetDirectory(String targetId) {
        File dir = new File(this.configurationMngr.getWorkingDirectory(), "targets");
        return new File(dir, targetId);
    }

    private File findTargetFile(String targetId, String fileName) {
        File dir = null;
        File result = null;
        if (targetId != null && (dir = this.findTargetDirectory(targetId)).exists()) {
            result = new File(dir, fileName);
        }
        return result;
    }
}

