/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl.beans;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;

public class InstanceContext {
    private String instancePathOrComponentName;
    private final String name;
    private final String qualifier;

    public InstanceContext(AbstractApplication app, Instance inst) {
        this(app);
        this.instancePathOrComponentName = inst == null ? null : InstanceHelpers.computeInstancePath((Instance)inst);
    }

    public InstanceContext(String name, String qualifier, String instancePathOrComponentName) {
        this.name = name;
        this.qualifier = qualifier;
        this.instancePathOrComponentName = instancePathOrComponentName;
    }

    public InstanceContext(AbstractApplication app) {
        this.name = app.getName();
        this.qualifier = app instanceof ApplicationTemplate ? ((ApplicationTemplate)app).getVersion() : null;
    }

    public InstanceContext(AbstractApplication app, String instancePathOrComponentName) {
        this(app);
        this.instancePathOrComponentName = instancePathOrComponentName;
    }

    public String toString() {
        return this.name + "::" + this.qualifier + "::" + this.instancePathOrComponentName;
    }

    public static InstanceContext parse(String s) {
        Matcher m;
        String name = null;
        String qualifier = null;
        String instancePathOrComponentName = null;
        if (s != null && (m = Pattern.compile("(.*)::(.*)::(.*)").matcher(s)).matches()) {
            name = m.group(1).equals("null") ? null : m.group(1);
            qualifier = m.group(2).equals("null") ? null : m.group(2);
            instancePathOrComponentName = m.group(3).equals("null") ? null : m.group(3);
        }
        return new InstanceContext(name, qualifier, instancePathOrComponentName);
    }

    public int hashCode() {
        int i1 = this.name == null ? 11 : this.name.hashCode();
        int i2 = this.qualifier == null ? 3 : this.qualifier.hashCode();
        return i1 + i2;
    }

    public boolean equals(Object obj) {
        return obj instanceof InstanceContext && Objects.equals(this.name, ((InstanceContext)obj).name) && Objects.equals(this.qualifier, ((InstanceContext)obj).qualifier) && Objects.equals(this.instancePathOrComponentName, ((InstanceContext)obj).instancePathOrComponentName);
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getInstancePathOrComponentName() {
        return this.instancePathOrComponentName;
    }
}

