/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.api.ICommandsMngr;
import net.roboconf.dm.management.exceptions.CommandException;

public abstract class AbstractCommandExecution {
    protected ICommandsMngr.CommandExecutionContext executionContext;

    abstract void execute() throws CommandException;

    protected ManagedApplication resolveManagedApplication(Manager manager, AbstractCommandInstruction instr) throws CommandException {
        String appName = instr.getApplication().getName();
        ManagedApplication ma = manager.applicationMngr().findManagedApplicationByName(appName);
        if (ma == null) {
            throw new CommandException("Application " + appName + " could not be found.");
        }
        return ma;
    }

    protected Instance resolveInstance(AbstractCommandInstruction instr, String instancePath, boolean nullIsAllowed) throws CommandException {
        Instance instance = InstanceHelpers.findInstanceByPath((AbstractApplication)instr.getApplication(), (String)instancePath);
        if (!(instance != null || nullIsAllowed && instancePath == null)) {
            throw new CommandException("Instance " + instancePath + " could not be found.");
        }
        return instance;
    }

    public void setExecutionContext(ICommandsMngr.CommandExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

