/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.roboconf.core.commands.AppendCommandInstruction;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.commands.AbstractCommandExecution;
import net.roboconf.dm.management.exceptions.CommandException;

class AppendCommandExecution
extends AbstractCommandExecution {
    private final AppendCommandInstruction instr;

    public AppendCommandExecution(AppendCommandInstruction instr) {
        this.instr = instr;
    }

    @Override
    public void execute() throws CommandException {
        OutputStreamWriter fw = null;
        try {
            File f = new File(this.instr.getFilePath());
            boolean append = f.exists() && f.length() > 0L;
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), StandardCharsets.UTF_8);
            if (append) {
                fw.append("\n");
            }
            fw.append(this.instr.getContent());
        }
        catch (IOException e) {
            try {
                throw new CommandException(e);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(fw);
                throw throwable;
            }
        }
        Utils.closeQuietly((Writer)fw);
    }
}

