/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.BulkCommandInstructions;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.internal.commands.AbstractCommandExecution;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.exceptions.CommandException;

class BulkCommandExecution
extends AbstractCommandExecution {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final BulkCommandInstructions instr;
    private final Manager manager;

    public BulkCommandExecution(BulkCommandInstructions instr, Manager manager) {
        this.instr = instr;
        this.manager = manager;
    }

    @Override
    public void execute() throws CommandException {
        ManagedApplication ma = this.resolveManagedApplication(this.manager, (AbstractCommandInstruction)this.instr);
        ArrayList<Instance> instances = new ArrayList<Instance>();
        if (this.instr.getInstancePath() != null) {
            Instance instance = this.resolveInstance((AbstractCommandInstruction)this.instr, this.instr.getInstancePath(), false);
            instances.add(instance);
        } else {
            instances.addAll(InstanceHelpers.findInstancesByComponentName((AbstractApplication)this.instr.getApplication(), (String)this.instr.getComponentName()));
        }
        try {
            switch (this.instr.getChangeStateInstruction()) {
                case DEPLOY_AND_START_ALL: {
                    for (Instance inst : instances) {
                        this.manager.instancesMngr().deployAndStartAll(ma, inst);
                    }
                    break;
                }
                case STOP_ALL: {
                    for (Instance inst : instances) {
                        this.manager.instancesMngr().stopAll(ma, inst);
                    }
                    break;
                }
                case UNDEPLOY_ALL: {
                    for (Instance inst : instances) {
                        this.manager.instancesMngr().undeployAll(ma, inst);
                    }
                    break;
                }
                case DELETE: {
                    for (Instance inst : instances) {
                        this.manager.instancesMngr().removeInstance(ma, inst, false);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

