/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import java.io.File;
import java.util.Collection;
import java.util.logging.Logger;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.AppendCommandInstruction;
import net.roboconf.core.commands.AssociateTargetCommandInstruction;
import net.roboconf.core.commands.BulkCommandInstructions;
import net.roboconf.core.commands.ChangeStateCommandInstruction;
import net.roboconf.core.commands.CommandsParser;
import net.roboconf.core.commands.CreateInstanceCommandInstruction;
import net.roboconf.core.commands.EmailCommandInstruction;
import net.roboconf.core.commands.ExecuteCommandInstruction;
import net.roboconf.core.commands.RenameCommandInstruction;
import net.roboconf.core.commands.ReplicateCommandInstruction;
import net.roboconf.core.commands.WriteCommandInstruction;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.dm.internal.commands.AbstractCommandExecution;
import net.roboconf.dm.internal.commands.AppendCommandExecution;
import net.roboconf.dm.internal.commands.AssociateTargetCommandExecution;
import net.roboconf.dm.internal.commands.BulkCommandExecution;
import net.roboconf.dm.internal.commands.ChangeStateCommandExecution;
import net.roboconf.dm.internal.commands.CreateInstanceCommandExecution;
import net.roboconf.dm.internal.commands.EmailCommandExecution;
import net.roboconf.dm.internal.commands.ExecuteCommandExecution;
import net.roboconf.dm.internal.commands.RenameCommandExecution;
import net.roboconf.dm.internal.commands.ReplicateCommandExecution;
import net.roboconf.dm.internal.commands.WriteCommandExecution;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.api.ICommandsMngr;
import net.roboconf.dm.management.exceptions.CommandException;

public class CommandsExecutor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final File commandsFile;
    private final Application app;
    private final Manager manager;
    private final ICommandsMngr.CommandExecutionContext executionContext;
    private boolean instructionSkipped = false;

    public CommandsExecutor(Manager manager, Application app, File commandsFile) {
        this(manager, app, commandsFile, null);
    }

    public CommandsExecutor(Manager manager, Application app, File commandsFile, ICommandsMngr.CommandExecutionContext executionContext) {
        this.commandsFile = commandsFile;
        this.app = app;
        this.manager = manager;
        this.executionContext = executionContext;
    }

    public void execute() throws CommandException {
        try {
            CommandsParser parser = new CommandsParser((AbstractApplication)this.app, this.commandsFile);
            if (RoboconfErrorHelpers.containsCriticalErrors((Collection)parser.getParsingErrors())) {
                throw new CommandException("Invalid command file. " + this.commandsFile.getName() + " contains errors.");
            }
            for (AbstractCommandInstruction instr : parser.getInstructions()) {
                if (instr.isDisabled()) {
                    this.logger.fine("Skipping disabled instruction: " + instr.getClass().getSimpleName());
                    this.instructionSkipped = true;
                    continue;
                }
                AbstractCommandExecution executor = this.findExecutor(instr);
                if (executor == null) {
                    this.logger.fine("Skipping non-executable instruction: " + instr.getClass().getSimpleName());
                    continue;
                }
                executor.setExecutionContext(this.executionContext);
                executor.execute();
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public boolean wereInstructionSkipped() {
        return this.instructionSkipped;
    }

    AbstractCommandExecution findExecutor(AbstractCommandInstruction instr) {
        AbstractCommandExecution result = null;
        if (RenameCommandInstruction.class.equals(instr.getClass())) {
            result = new RenameCommandExecution((RenameCommandInstruction)instr);
        } else if (ReplicateCommandInstruction.class.equals(instr.getClass())) {
            result = new ReplicateCommandExecution((ReplicateCommandInstruction)instr, this.manager);
        } else if (AssociateTargetCommandInstruction.class.equals(instr.getClass())) {
            result = new AssociateTargetCommandExecution((AssociateTargetCommandInstruction)instr, this.manager);
        } else if (BulkCommandInstructions.class.equals(instr.getClass())) {
            result = new BulkCommandExecution((BulkCommandInstructions)instr, this.manager);
        } else if (ChangeStateCommandInstruction.class.equals(instr.getClass())) {
            result = new ChangeStateCommandExecution((ChangeStateCommandInstruction)instr, this.manager);
        } else if (CreateInstanceCommandInstruction.class.equals(instr.getClass())) {
            result = new CreateInstanceCommandExecution((CreateInstanceCommandInstruction)instr, this.manager);
        } else if (EmailCommandInstruction.class.equals(instr.getClass())) {
            result = new EmailCommandExecution((EmailCommandInstruction)instr, this.manager);
        } else if (WriteCommandInstruction.class.equals(instr.getClass())) {
            result = new WriteCommandExecution((WriteCommandInstruction)instr);
        } else if (AppendCommandInstruction.class.equals(instr.getClass())) {
            result = new AppendCommandExecution((AppendCommandInstruction)instr);
        } else if (ExecuteCommandInstruction.class.equals(instr.getClass())) {
            result = new ExecuteCommandExecution((ExecuteCommandInstruction)instr, this.manager);
        }
        return result;
    }
}

