/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.ReplicateCommandInstruction;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.internal.commands.AbstractCommandExecution;
import net.roboconf.dm.internal.commands.CreateInstanceCommandExecution;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.exceptions.CommandException;

class ReplicateCommandExecution
extends AbstractCommandExecution {
    private final ReplicateCommandInstruction instr;
    private final Manager manager;

    public ReplicateCommandExecution(ReplicateCommandInstruction instr, Manager manager) {
        this.instr = instr;
        this.manager = manager;
    }

    @Override
    public void execute() throws CommandException {
        Instance rootInstance = this.resolveInstance((AbstractCommandInstruction)this.instr, this.instr.getReplicatedInstancePath(), true);
        ManagedApplication ma = this.resolveManagedApplication(this.manager, (AbstractCommandInstruction)this.instr);
        CreateInstanceCommandExecution.verify(this.executionContext, rootInstance.getComponent());
        try {
            Instance copy = InstanceHelpers.replicateInstance((Instance)rootInstance);
            copy.setName(this.instr.getNewInstanceName());
            this.manager.instancesMngr().addInstance(ma, null, copy);
            String targetId = this.manager.targetsMngr().findTargetId((AbstractApplication)ma.getApplication(), "/" + rootInstance.getName(), true);
            if (targetId != null) {
                this.manager.targetsMngr().associateTargetWith(targetId, (AbstractApplication)ma.getApplication(), "/" + copy.getName());
            }
            CreateInstanceCommandExecution.update(this.executionContext, copy);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

