/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.utils.IconUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;

public final class ConfigurationUtils {
    public static final String TEMPLATES = "application-templates";
    public static final String APPLICATIONS = "applications";
    public static final String TARGETS = "targets";
    public static final String INSTANCES_FILE = "current.instances";
    public static final String APP_BINDINGS_FILE = "application-bindings.properties";
    public static final String TARGETS_ASSOC_FILE = "targets-associations.properties";
    public static final String TARGETS_HINTS_SUFFIX = ".hints.properties";
    public static final String TARGETS_USAGE_SUFFIX = ".usage.properties";

    private ConfigurationUtils() {
    }

    public static File findApplicationDirectory(String applicationName, File configurationDirectory) {
        return new File(configurationDirectory, "applications/" + applicationName);
    }

    public static File findTemplateDirectory(ApplicationTemplate tpl, File configurationDirectory) {
        StringBuilder sb = new StringBuilder(TEMPLATES);
        sb.append("/");
        sb.append(tpl.getName());
        if (!Utils.isEmptyOrWhitespaces((String)tpl.getVersion())) {
            sb.append(" - ");
            sb.append(tpl.getVersion());
        }
        return new File(configurationDirectory, sb.toString());
    }

    public static void saveInstances(ManagedApplication ma) {
        ConfigurationUtils.saveInstances(ma.getApplication());
    }

    public static void saveInstances(Application app) {
        File targetFile = new File(app.getDirectory(), "instances/current.instances");
        try {
            Utils.createDirectory((File)targetFile.getParentFile());
            RuntimeModelIo.writeInstances((File)targetFile, (Collection)app.getRootInstances());
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(ConfigurationUtils.class.getName());
            logger.severe("Failed to save instances. " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
    }

    public static RuntimeModelIo.InstancesLoadResult restoreInstances(ManagedApplication ma) {
        File sourceFile = new File(ma.getDirectory(), "instances/current.instances");
        Graphs graphs = ma.getApplication().getTemplate().getGraphs();
        RuntimeModelIo.InstancesLoadResult result = sourceFile.exists() ? RuntimeModelIo.loadInstances((File)sourceFile, (File)sourceFile.getParentFile(), (Graphs)graphs, (String)ma.getApplication().getName()) : new RuntimeModelIo.InstancesLoadResult();
        return result;
    }

    public static File findIcon(String name, String qualifier, File configurationDirectory) {
        File root;
        if (configurationDirectory == null) {
            return null;
        }
        if (!Utils.isEmptyOrWhitespaces((String)qualifier)) {
            ApplicationTemplate tpl = new ApplicationTemplate(name).version(qualifier);
            root = ConfigurationUtils.findTemplateDirectory(tpl, configurationDirectory);
        } else {
            root = ConfigurationUtils.findApplicationDirectory(name, configurationDirectory);
        }
        return IconUtils.findIcon((File)root);
    }

    public static void loadApplicationBindings(Application app) {
        File descDir = new File(app.getDirectory(), "descriptor");
        File appBindingsFile = new File(descDir, APP_BINDINGS_FILE);
        Logger logger = Logger.getLogger(ConfigurationUtils.class.getName());
        Properties props = Utils.readPropertiesFileQuietly((File)appBindingsFile, (Logger)logger);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            for (String part : Utils.splitNicely((String)((String)entry.getValue()), (String)",")) {
                if (Utils.isEmptyOrWhitespaces((String)part)) continue;
                app.bindWithApplication((String)entry.getKey(), part);
            }
        }
    }

    public static void saveApplicationBindings(Application app) {
        File descDir = new File(app.getDirectory(), "descriptor");
        File appBindingsFile = new File(descDir, APP_BINDINGS_FILE);
        HashMap format = new HashMap();
        for (Map.Entry entry : app.getApplicationBindings().entrySet()) {
            String s = Utils.format((Collection)((Collection)entry.getValue()), (String)", ");
            format.put(entry.getKey(), s);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)format);
        try {
            Utils.createDirectory((File)descDir);
            Utils.writePropertiesFile((Properties)props, (File)appBindingsFile);
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(ConfigurationUtils.class.getName());
            logger.severe("Failed to save application bindings for " + app + ". " + e.getMessage());
            Utils.logException((Logger)logger, (Throwable)e);
        }
    }
}

