/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.dependency.impl;

import java.util.Collection;
import java.util.List;
import org.apache.felix.ipojo.context.ServiceReferenceImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReferenceUtils {
    public static boolean match(Filter filter, ServiceReference ref) {
        boolean match = true;
        if (filter != null) {
            match = ref instanceof ServiceReferenceImpl ? filter.match(((ServiceReferenceImpl)ref).getProperties()) : filter.match(ref);
        }
        return match;
    }

    public static boolean containsReferenceById(List<? extends ServiceReference> references, ServiceReference ref) {
        return ServiceReferenceUtils.getServiceReferenceById(references, ref) != null;
    }

    public static ServiceReference getServiceReferenceById(List<? extends ServiceReference> references, ServiceReference ref) {
        Object id = ref.getProperty("service.id");
        for (ServiceReference serviceReference : references) {
            if (!serviceReference.getProperty("service.id").equals(id)) continue;
            return serviceReference;
        }
        return null;
    }

    public static boolean haveSameProperties(ServiceReference ref1, ServiceReference ref2) {
        if (ref2 == null && ref1 == null) {
            return true;
        }
        if (ref1 == null || ref2 == null) {
            return false;
        }
        String[] keys = ref2.getPropertyKeys();
        if (ref2.getPropertyKeys().length != keys.length) {
            return false;
        }
        for (String key : keys) {
            if (ref2.getProperty(key).equals(ref1.getProperty(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean haveSameServiceId(ServiceReference ref1, ServiceReference ref2) {
        return ref1 != null && ref2 != null && ref1.getProperty("service.id").equals(ref2.getProperty("service.id"));
    }

    public static String toString(Collection<? extends ServiceReference> references) {
        if (references == null || references.isEmpty()) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder("[");
        for (ServiceReference serviceReference : references) {
            if (buffer.length() == 1) {
                buffer.append(serviceReference.getProperty("service.id"));
                continue;
            }
            buffer.append(", ").append(serviceReference.getProperty("service.id"));
        }
        buffer.append("]");
        return buffer.toString();
    }
}

