/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version {
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;

    private Version(int major, int minor, int patch, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public static Version parseVersion(String rawVersion) {
        Version result = null;
        Matcher m = Pattern.compile("^(\\d+)\\.(\\d+)(\\.\\d+)?([.-].+)?$").matcher(rawVersion);
        if (m.find()) {
            result = new Version(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), m.group(3) == null ? 0 : Integer.parseInt(m.group(3).substring(1)), m.group(4) == null ? null : m.group(4).substring(1));
        }
        return result;
    }
}

