/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.helpers.ComponentHelpers;

public class BulkCommandInstructions
extends AbstractCommandInstruction {
    private static final String ALL = "\\s+instances\\s+of";
    private String instancePath;
    private String componentName;
    private ChangeStateInstruction changeStateInstruction;

    BulkCommandInstructions(Context context, String instruction, int line) {
        super(context, instruction, line);
        Matcher m = BulkCommandInstructions.getPatternForInstancePath().matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.instancePath = m.group(2).trim();
            this.changeStateInstruction = ChangeStateInstruction.which(m.group(1).trim());
        } else {
            m = BulkCommandInstructions.getPatternForComponentName().matcher(instruction);
            if (m.matches()) {
                this.syntaxicallyCorrect = true;
                this.componentName = m.group(2).trim();
                this.changeStateInstruction = ChangeStateInstruction.which(m.group(1).trim());
            }
        }
    }

    public static boolean isBulkInstruction(String line) {
        Pattern[] patterns;
        boolean match = false;
        for (Pattern p : patterns = new Pattern[]{BulkCommandInstructions.getPatternForInstancePath(), BulkCommandInstructions.getPatternForComponentName()}) {
            Matcher m = p.matcher(line);
            if (!m.matches() || ChangeStateInstruction.which(m.group(1).trim()) == null) continue;
            match = true;
            break;
        }
        return match;
    }

    private static Pattern getPatternForInstancePath() {
        return Pattern.compile("([^/]+)(/.*)", 2);
    }

    private static Pattern getPatternForComponentName() {
        return Pattern.compile("(.+)\\s+instances\\s+of(.+)", 2);
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (this.changeStateInstruction == null) {
            result.add(this.error(ErrorCode.CMD_UNRECOGNIZED_INSTRUCTION));
        }
        if (this.instancePath != null && !this.context.instanceExists(this.instancePath)) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE, ErrorDetails.instance(this.instancePath)));
        }
        if (this.componentName != null && ComponentHelpers.findComponent(this.context.getApp(), this.componentName) == null) {
            result.add(this.error(ErrorCode.CMD_INEXISTING_COMPONENT, ErrorDetails.instance(this.instancePath)));
        }
        return result;
    }

    @Override
    public void updateContext() {
        if (this.changeStateInstruction == ChangeStateInstruction.DELETE) {
            HashSet<String> pathOfInstancesToRemove = new HashSet<String>();
            if (this.instancePath != null) {
                pathOfInstancesToRemove.add(this.instancePath);
            } else {
                for (Map.Entry<String, String> entry : this.context.instancePathToComponentName.entrySet()) {
                    if (!this.componentName.equals(entry.getValue())) continue;
                    pathOfInstancesToRemove.add(entry.getKey());
                }
            }
            ArrayList<String> keys = new ArrayList<String>(this.context.instancePathToComponentName.keySet());
            for (String path : keys) {
                for (String pathToRemove : pathOfInstancesToRemove) {
                    if (!path.equals(pathToRemove) && !path.startsWith(pathToRemove + "/")) continue;
                    this.context.instancePathToComponentName.remove(path);
                }
            }
        }
    }

    public String getInstancePath() {
        return this.instancePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ChangeStateInstruction getChangeStateInstruction() {
        return this.changeStateInstruction;
    }

    public static enum ChangeStateInstruction {
        DELETE,
        DEPLOY_AND_START_ALL,
        STOP_ALL,
        UNDEPLOY_ALL;


        public String toString() {
            return super.toString().replace('_', ' ').toLowerCase();
        }

        public static ChangeStateInstruction which(String s) {
            ChangeStateInstruction result = null;
            for (ChangeStateInstruction elt : ChangeStateInstruction.values()) {
                if (elt.toString().equalsIgnoreCase(s)) {
                    result = elt;
                    break;
                }
                if (!(elt.toString() + " all").equalsIgnoreCase(s)) continue;
                result = elt;
                break;
            }
            return result;
        }
    }
}

