/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.AppendCommandInstruction;
import net.roboconf.core.commands.AssociateTargetCommandInstruction;
import net.roboconf.core.commands.BulkCommandInstructions;
import net.roboconf.core.commands.ChangeStateCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.commands.CreateInstanceCommandInstruction;
import net.roboconf.core.commands.DefineVariableCommandInstruction;
import net.roboconf.core.commands.EmailCommandInstruction;
import net.roboconf.core.commands.ExecuteCommandInstruction;
import net.roboconf.core.commands.RenameCommandInstruction;
import net.roboconf.core.commands.ReplicateCommandInstruction;
import net.roboconf.core.commands.WriteCommandInstruction;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.utils.Utils;

public class CommandsParser {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<ParsingError> parsingErrors = new ArrayList<ParsingError>();
    private final Context context;
    final List<AbstractCommandInstruction> instructions = new ArrayList<AbstractCommandInstruction>();

    public CommandsParser(AbstractApplication app, File commandsFile) {
        this.context = new Context(app, commandsFile);
        this.parse();
    }

    public CommandsParser(AbstractApplication app, String instructionsText) {
        this.context = new Context(app, null);
        if (instructionsText != null) {
            this.parse(instructionsText);
        }
    }

    public List<ParsingError> getParsingErrors() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>(this.parsingErrors);
        if (this.context.getCommandFile() != null && !this.context.getCommandFile().exists()) {
            result.add(0, new ParsingError(ErrorCode.CMD_INEXISTING_COMMAND_FILE, this.context.getCommandFile(), 1));
        } else if (this.instructions.isEmpty()) {
            result.add(0, new ParsingError(ErrorCode.CMD_NO_INSTRUCTION, this.context.getCommandFile(), 1));
        }
        return result;
    }

    public List<AbstractCommandInstruction> getInstructions() {
        return this.instructions;
    }

    public static String injectContextVariables(String line, Map<String, String> context) {
        String result = line;
        for (Map.Entry<String, String> entry : context.entrySet()) {
            result = result.replace("$(" + entry.getKey() + ")", entry.getValue());
        }
        return result;
    }

    private void parse() {
        try {
            String fileContent = Utils.readFileContent(this.context.getCommandFile());
            this.parse(fileContent);
        }
        catch (IOException e) {
            this.logger.severe("A commands file could not be read. File path: " + this.context.getName());
        }
    }

    private void parse(String instructionsText) {
        String sep = "!@!";
        instructionsText = instructionsText.replaceAll("\\\\\n\\s*", "!@!");
        int lineNumber = 0;
        for (String string : Utils.splitNicely(instructionsText, "\n")) {
            AbstractCommandInstruction instr;
            String line = string.trim();
            ++lineNumber;
            if ((line = line.replaceFirst("#.*", "")).isEmpty()) continue;
            int lineLength = line.length();
            line = line.replace("!@!", "");
            int lineCountOffset = (lineLength - line.length()) / "!@!".length();
            boolean disabled = false;
            for (String disabledVariableName : this.context.disabledVariables) {
                if (!line.contains("$(" + disabledVariableName + ")")) continue;
                disabled = true;
                break;
            }
            if ((instr = this.parse(line = CommandsParser.injectContextVariables(line, this.context.variables), lineNumber)) != null) {
                instr.setDisabled(disabled);
                List<ParsingError> errors = instr.validate();
                if (errors.isEmpty()) {
                    instr.updateContext();
                } else {
                    this.parsingErrors.addAll(errors);
                }
                this.instructions.add(instr);
            } else {
                this.logger.severe("An invalid instruction was found in " + this.context.getName() + ": " + line);
                this.parsingErrors.add(new ParsingError(ErrorCode.CMD_UNRECOGNIZED_INSTRUCTION, this.context.getCommandFile(), lineNumber, ErrorDetails.instruction(line)));
            }
            lineNumber += lineCountOffset;
        }
    }

    private AbstractCommandInstruction parse(String line, int lineNumber) {
        AbstractCommandInstruction result = null;
        String toLowerCase = line.toLowerCase();
        if (toLowerCase.startsWith("associate")) {
            result = new AssociateTargetCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("change")) {
            result = new ChangeStateCommandInstruction(this.context, line, lineNumber);
        } else if (BulkCommandInstructions.isBulkInstruction(toLowerCase)) {
            result = new BulkCommandInstructions(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("email")) {
            result = new EmailCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("define")) {
            result = new DefineVariableCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("create")) {
            result = new CreateInstanceCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("replicate")) {
            result = new ReplicateCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("rename")) {
            result = new RenameCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("write")) {
            result = new WriteCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("append")) {
            result = new AppendCommandInstruction(this.context, line, lineNumber);
        } else if (toLowerCase.startsWith("execute")) {
            result = new ExecuteCommandInstruction(this.context, line, lineNumber);
        }
        return result;
    }
}

