/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.CommandsParser;
import net.roboconf.core.commands.Context;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;

public class DefineVariableCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "define";
    public static final String MILLI_TIME = "$(MILLI_TIME)";
    public static final String NANO_TIME = "$(NANO_TIME)";
    public static final String FORMATTED_TIME_PREFIX = "$(FORMATTED_TIME ";
    public static final String EXISTING_INDEX_PREFIX = "$(EXISTING_INDEX ";
    public static final String RANDOM_UUID = "$(UUID)";
    public static final String SMART_INDEX = "$(SMART_INDEX)";
    static final String FAKE_COMPONENT_NAME = "@fake-component@";
    private static final String EXISTING_INDEX_PATTERN = "(.*)" + Pattern.quote("$(EXISTING_INDEX ") + "\\s*((MIN)|(MAX))\\s*([<>]\\s*\\d+)?\\s*\\)(.*)";
    private String key;
    private String value;
    private String instancePath;

    DefineVariableCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("define\\s+([^=]*)\\s*=\\s*(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.key = m.group(1).trim();
            this.value = m.group(2).trim();
            Pattern subP = Pattern.compile("(.*)\\s+under\\s+(.*)", 2);
            m = subP.matcher(this.value);
            if (m.matches()) {
                this.value = m.group(1).trim();
                this.instancePath = m.group(2).trim();
            }
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(this.key)) {
            result.add(this.error(ErrorCode.CMD_EMPTY_VARIABLE_NAME));
        } else if (this.value.startsWith(FORMATTED_TIME_PREFIX) && this.value.endsWith(")")) {
            String datePattern = DefineVariableCommandInstruction.extractDatePattern(this.value);
            if (datePattern.contains("$(")) {
                result.add(this.error(ErrorCode.CMD_NO_MIX_FOR_PATTERNS, ErrorDetails.variable(this.key)));
            } else {
                try {
                    new SimpleDateFormat(datePattern);
                }
                catch (Exception e) {
                    result.add(this.error(ErrorCode.CMD_INVALID_DATE_PATTERN, ErrorDetails.value(datePattern)));
                }
            }
        } else if (this.value.contains(FORMATTED_TIME_PREFIX)) {
            result.add(this.error(ErrorCode.CMD_NO_MIX_FOR_PATTERNS, ErrorDetails.variable(this.value)));
        }
        Pattern indexPattern = Pattern.compile(EXISTING_INDEX_PATTERN);
        if (this.value.contains(EXISTING_INDEX_PREFIX) && !indexPattern.matcher(this.value).matches()) {
            result.add(this.error(ErrorCode.CMD_INVALID_INDEX_PATTERN, ErrorDetails.variable(this.value)));
        }
        if (result.isEmpty() && this.instancePath != null && !this.context.instanceExists(this.instancePath)) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE));
        }
        return result;
    }

    @Override
    public void updateContext() {
        String newValue = DefineVariableCommandInstruction.replaceVariables(this.value, this.context, this.instancePath);
        if (newValue != null) {
            this.context.variables.put(this.key, newValue);
        } else {
            this.setDisabled(true);
            this.context.disabledVariables.add(this.key);
            this.context.variables.put(this.key, "fake");
            String path = "/fake";
            if (this.instancePath != null) {
                path = this.instancePath + path;
            }
            this.context.instancePathToComponentName.put(path, FAKE_COMPONENT_NAME);
        }
    }

    @Override
    protected List<String> getVariablesToIgnore() {
        ArrayList<String> variablesToIgnore = new ArrayList<String>();
        variablesToIgnore.add("^" + Pattern.quote(MILLI_TIME) + "$");
        variablesToIgnore.add("^" + Pattern.quote(NANO_TIME) + "$");
        variablesToIgnore.add("^" + Pattern.quote(SMART_INDEX) + "$");
        variablesToIgnore.add("^" + Pattern.quote(RANDOM_UUID) + "$");
        for (String var : this.context.variables.keySet()) {
            variablesToIgnore.add("^\\$\\(" + Pattern.quote(var) + "\\)$");
        }
        variablesToIgnore.add("^" + Pattern.quote(FORMATTED_TIME_PREFIX) + "[^)]*\\)$");
        variablesToIgnore.add("^" + Pattern.quote(EXISTING_INDEX_PREFIX) + "[^)]*\\)$");
        return variablesToIgnore;
    }

    static String extractDatePattern(String group) {
        return group.substring(FORMATTED_TIME_PREFIX.length(), group.length() - 2).trim();
    }

    static String replaceVariables(String value, Context context, String parentInstancePath) {
        long nanoTime = System.nanoTime();
        long milliTime = TimeUnit.MILLISECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
        value = value.replace(NANO_TIME, String.valueOf(nanoTime));
        value = value.replace(MILLI_TIME, String.valueOf(milliTime));
        if ((value = value.replace(RANDOM_UUID, UUID.randomUUID().toString())).startsWith(FORMATTED_TIME_PREFIX) && value.endsWith(")")) {
            String datePattern = DefineVariableCommandInstruction.extractDatePattern(value);
            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
            value = sdf.format(new Date(milliTime));
        }
        int smartCpt = 0;
        if (value.contains(SMART_INDEX)) {
            int cpt = 1;
            while (smartCpt == 0) {
                String testName = value.replace(SMART_INDEX, String.valueOf(cpt));
                String testPath = "/" + testName;
                if (parentInstancePath != null) {
                    testPath = parentInstancePath + testPath;
                }
                if (!context.instanceExists(testPath)) {
                    smartCpt = cpt;
                }
                ++cpt;
            }
        }
        value = value.replace(SMART_INDEX, String.valueOf(smartCpt));
        boolean disabled = false;
        Pattern fullPattern = Pattern.compile(EXISTING_INDEX_PATTERN);
        Matcher m = fullPattern.matcher(value);
        if (value.contains(EXISTING_INDEX_PREFIX) && m.matches()) {
            int cpt;
            String minOrMax = m.group(2);
            String prefix = m.group(1);
            String suffix = m.group(6);
            String bound = m.group(5);
            String instanceNamePattern = "/" + prefix + "(\\d+)" + suffix;
            if (parentInstancePath != null) {
                instanceNamePattern = parentInstancePath + instanceNamePattern;
            }
            if ((cpt = DefineVariableCommandInstruction.findIndex(instanceNamePattern, context, bound, "MIN".equals(minOrMax))) < 0) {
                disabled = true;
            } else {
                value = m.replaceAll("$1" + String.valueOf(cpt) + "$6");
            }
        }
        value = disabled ? null : CommandsParser.injectContextVariables(value, context.variables);
        return value;
    }

    private static int findIndex(String instanceNamePattern, Context context, String bound, boolean findMinimum) {
        Pattern pattern = Pattern.compile(instanceNamePattern);
        TreeSet<Integer> foundIndexes = new TreeSet<Integer>();
        for (String instancePath : context.instancePathToComponentName.keySet()) {
            Matcher m = pattern.matcher(instancePath);
            if (!m.find()) continue;
            int index = Integer.parseInt(m.group(1));
            foundIndexes.add(index);
        }
        if (bound != null) {
            bound = bound.trim();
            int min = 0;
            int max = Integer.MAX_VALUE;
            int value = Integer.parseInt(bound.substring(1).trim());
            if ('<' == bound.charAt(0)) {
                max = value;
            } else {
                min = value;
            }
            HashSet<Integer> toRemove = new HashSet<Integer>();
            for (Integer index : foundIndexes) {
                if (index > min && index < max) continue;
                toRemove.add(index);
            }
            foundIndexes.removeAll(toRemove);
        }
        int result = foundIndexes.isEmpty() ? -1 : (findMinimum ? ((Integer)foundIndexes.first()).intValue() : ((Integer)foundIndexes.last()).intValue());
        return result;
    }
}

